/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfElementInfo
implements SmartPointerElementInfo {
    protected final VirtualFile myVirtualFile;
    private Reference<RangeMarker> myMarkerRef;
    private volatile int mySyncStartOffset;
    private volatile int mySyncEndOffset;
    protected volatile boolean mySyncMarkerIsValid;
    private final Class myType;
    protected final Project myProject;
    private volatile RangeMarker myRangeMarker;
    protected final Language myLanguage;

    SelfElementInfo(@NotNull Project project, @NotNull ProperTextRange range, @NotNull Class anchorClass, @NotNull PsiFile containingFile, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (anchorClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorClass", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        this.myLanguage = language;
        this.myVirtualFile = PsiUtilCore.getVirtualFile(containingFile);
        this.myType = anchorClass;
        assert (!PsiFile.class.isAssignableFrom(anchorClass)) : "FileElementInfo must be used for files";
        this.myProject = project;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.myProject);
        Document document = documentManager.getCachedDocument(containingFile);
        if (document != null && documentManager.isUncommited(document)) {
            this.mySyncMarkerIsValid = false;
        } else {
            this.mySyncMarkerIsValid = true;
            this.setRange(range);
        }
    }

    protected void setRange(@NotNull Segment range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "setRange"));
        }
        this.mySyncStartOffset = range.getStartOffset();
        this.mySyncEndOffset = range.getEndOffset();
    }

    @Override
    public Document getDocumentToSynchronize() {
        RangeMarker marker = this.getMarker();
        if (marker != null) {
            return marker.getDocument();
        }
        return this.myVirtualFile == null ? null : FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
    }

    @Override
    public void fastenBelt(int offset, @Nullable RangeMarker[] cachedRangeMarkers) {
        int actualEndOffset;
        if (!this.mySyncMarkerIsValid) {
            return;
        }
        RangeMarker marker = this.getMarker();
        int n = actualEndOffset = marker == null || !marker.isValid() ? this.getSyncEndOffset() : marker.getEndOffset();
        if (offset > actualEndOffset) {
            return;
        }
        if (marker == null) {
            Document document;
            Document document2 = document = this.myVirtualFile == null ? null : FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
            if (document == null) {
                this.mySyncMarkerIsValid = false;
            } else {
                int start = Math.min(this.getSyncStartOffset(), document.getTextLength());
                int end = Math.min(Math.max(this.getSyncEndOffset(), start), document.getTextLength());
                if (cachedRangeMarkers != null) {
                    for (RangeMarker cachedRangeMarker : cachedRangeMarkers) {
                        if (!cachedRangeMarker.isValid() || cachedRangeMarker.getStartOffset() != start || cachedRangeMarker.getEndOffset() != end) continue;
                        marker = cachedRangeMarker;
                        break;
                    }
                }
                if (marker == null) {
                    marker = document.createRangeMarker(start, end, true);
                }
            }
            this.setMarker(marker);
        } else if (marker.isValid()) {
            this.setRange(marker);
        } else {
            this.mySyncMarkerIsValid = false;
            this.setMarker(null);
            marker = null;
        }
        this.myRangeMarker = marker;
    }

    @Override
    public void unfastenBelt(int offset) {
        if (!this.mySyncMarkerIsValid) {
            return;
        }
        RangeMarker marker = this.getMarker();
        if (marker != null) {
            if (marker.isValid()) {
                this.setRange(marker);
                assert (this.mySyncEndOffset <= marker.getDocument().getTextLength()) : "mySyncEndOffset: " + this.mySyncEndOffset + "; docLength: " + marker.getDocument().getTextLength() + "; marker: " + marker + "; " + marker.getClass();
            } else {
                this.mySyncMarkerIsValid = false;
            }
        }
        this.myRangeMarker = null;
    }

    @Override
    public PsiElement restoreElement() {
        if (!this.mySyncMarkerIsValid) {
            return null;
        }
        PsiFile file = this.restoreFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        return this.restoreFromFile(file);
    }

    protected PsiElement restoreFromFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFromFile"));
        }
        int syncStartOffset = this.getSyncStartOffset();
        int syncEndOffset = this.getSyncEndOffset();
        return SelfElementInfo.findElementInside(file, syncStartOffset, syncEndOffset, this.myType, this.myLanguage);
    }

    @Override
    public PsiFile restoreFile() {
        return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
    }

    protected static PsiElement findElementInside(@NotNull PsiFile file, int syncStartOffset, int syncEndOffset, @NotNull Class type, @NotNull Language language) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        PsiElement anchor = file.getViewProvider().findElementAt(syncStartOffset, language);
        if (anchor == null) {
            return null;
        }
        TextRange range = anchor.getTextRange();
        if (range.getStartOffset() != syncStartOffset) {
            return null;
        }
        while (range.getEndOffset() < syncEndOffset && (anchor = anchor.getParent()) != null && anchor.getTextRange() != null) {
            range = anchor.getTextRange();
        }
        while (range.getEndOffset() == syncEndOffset && anchor != null && !type.equals(anchor.getClass()) && (anchor = anchor.getParent()) != null && anchor.getTextRange() != null) {
            range = anchor.getTextRange();
        }
        return range.getEndOffset() == syncEndOffset ? anchor : null;
    }

    private RangeMarker getMarker() {
        return SoftReference.dereference(this.myMarkerRef);
    }

    @Override
    public void cleanup() {
        RangeMarker marker = this.getMarker();
        if (marker != null) {
            marker.dispose();
        }
        this.unfastenBelt(0);
        this.setMarker(null);
        this.mySyncMarkerIsValid = false;
    }

    private void setMarker(RangeMarker marker) {
        this.myMarkerRef = marker == null ? null : new java.lang.ref.SoftReference<RangeMarker>(marker);
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(final VirtualFile virtualFile, final @NotNull Project project, final @Nullable Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        if (virtualFile == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new NullableComputable<PsiFile>(){

            @Override
            public PsiFile compute() {
                VirtualFile child;
                if (project.isDisposed()) {
                    return null;
                }
                if (virtualFile.isValid()) {
                    child = virtualFile;
                } else {
                    VirtualFile vParent = virtualFile.getParent();
                    if (vParent == null || !vParent.isDirectory()) {
                        return null;
                    }
                    String name = virtualFile.getName();
                    child = vParent.findChild(name);
                }
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiFile file = PsiManager.getInstance(project).findFile(child);
                if (file != null && language != null) {
                    return file.getViewProvider().getPsi(language);
                }
                return file;
            }
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(final VirtualFile virtualFile, final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreDirectoryFromVirtual"));
        }
        if (virtualFile == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory>(){

            @Override
            public PsiDirectory compute() {
                VirtualFile child;
                if (virtualFile.isValid()) {
                    child = virtualFile;
                } else {
                    VirtualFile vParent = virtualFile.getParent();
                    if (vParent == null || !vParent.isDirectory()) {
                        return null;
                    }
                    String name = virtualFile.getName();
                    child = vParent.findChild(name);
                }
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiDirectory file = PsiManager.getInstance(project).findDirectory(child);
                if (file == null || !file.isValid()) {
                    return null;
                }
                return file;
            }
        });
    }

    protected int getSyncEndOffset() {
        return this.mySyncEndOffset;
    }

    protected int getSyncStartOffset() {
        return this.mySyncStartOffset;
    }

    @Override
    public int elementHashCode() {
        VirtualFile virtualFile = this.myVirtualFile;
        return virtualFile == null ? 0 : virtualFile.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof SelfElementInfo) {
            SelfElementInfo otherInfo = (SelfElementInfo)other;
            return Comparing.equal(this.myVirtualFile, otherInfo.myVirtualFile) && this.myType == otherInfo.myType && this.mySyncMarkerIsValid && otherInfo.mySyncMarkerIsValid && this.mySyncStartOffset == otherInfo.mySyncStartOffset && this.mySyncEndOffset == otherInfo.mySyncEndOffset;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return Comparing.equal(SelfElementInfo.this.restoreElement(), other.restoreElement());
            }
        });
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    public Segment getRange() {
        if (!this.mySyncMarkerIsValid) {
            return null;
        }
        return new TextRange(this.getSyncStartOffset(), this.getSyncEndOffset());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "getProject"));
        }
        return project;
    }
}

