/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.InheritedJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleSourceOrderEntryImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.InvalidDataException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class OrderEntryFactory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.OrderEntryFactory");
    @NonNls
    public static final String ORDER_ENTRY_ELEMENT_NAME = "orderEntry";
    @NonNls
    public static final String ORDER_ENTRY_TYPE_ATTR = "type";

    static OrderEntry createOrderEntryByElement(Element element, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        LOG.assertTrue(ORDER_ENTRY_ELEMENT_NAME.equals(element.getName()));
        String type = element.getAttributeValue(ORDER_ENTRY_TYPE_ATTR);
        if (type == null) {
            throw new InvalidDataException();
        }
        if ("sourceFolder".equals(type)) {
            return new ModuleSourceOrderEntryImpl(element, rootModel);
        }
        if ("jdk".equals(type)) {
            return new ModuleJdkOrderEntryImpl(element, rootModel, projectRootManager);
        }
        if ("inheritedJdk".equals(type)) {
            return new InheritedJdkOrderEntryImpl(element, rootModel, projectRootManager);
        }
        if ("library".equals(type)) {
            return new LibraryOrderEntryImpl(element, rootModel, projectRootManager);
        }
        if ("module-library".equals(type)) {
            return new ModuleLibraryOrderEntryImpl(element, rootModel, projectRootManager);
        }
        if ("module".equals(type)) {
            return new ModuleOrderEntryImpl(element, rootModel);
        }
        throw new InvalidDataException("Unknown order entry type:" + type);
    }

    static Element createOrderEntryElement(String type) {
        Element element = new Element(ORDER_ENTRY_ELEMENT_NAME);
        element.setAttribute(ORDER_ENTRY_TYPE_ATTR, type);
        return element;
    }
}

