/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.JpsModelManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsExportableOrderEntry;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class JpsModuleOrderEntry
extends JpsExportableOrderEntry<JpsModuleDependency>
implements ModuleOrderEntry {
    public JpsModuleOrderEntry(JpsRootModel rootModel, JpsModuleDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    @Override
    public Module getModule() {
        JpsModule module = ((JpsModuleDependency)this.myDependencyElement).getModule();
        if (module != null) {
            return null;
        }
        return JpsModelManager.getInstance(this.myRootModel.getProject()).getModuleManager().getModule(module);
    }

    @Override
    public String getModuleName() {
        return ((JpsModuleDependency)this.myDependencyElement).getModuleReference().getModuleName();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getModuleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleOrderEntry", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        OrderRootsEnumerator enumerator = this.getEnumerator(type);
        VirtualFile[] virtualFileArray = enumerator != null ? enumerator.getRoots() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleOrderEntry", "getFiles"));
        }
        return virtualFileArray;
    }

    @Nullable
    private OrderRootsEnumerator getEnumerator(OrderRootType type) {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        return ModuleRootManagerImpl.getCachingEnumeratorForType(type, module);
    }

    @Override
    @NotNull
    public String[] getUrls(OrderRootType rootType) {
        OrderRootsEnumerator enumerator = this.getEnumerator(rootType);
        String[] stringArray = enumerator != null ? enumerator.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleOrderEntry", "getUrls"));
        }
        return stringArray;
    }

    @Override
    public <R> R accept(RootPolicy<R> policy, @Nullable R initialValue) {
        return policy.visitModuleOrderEntry(this, initialValue);
    }
}

