/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlPsiUtil;
import com.intellij.xml.util.XmlPsiUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ScriptSupportUtil {
    private static final Key<CachedValue<XmlTag[]>> CachedScriptTagsKey = Key.create("script tags");
    private static final ThreadLocal<String> ProcessingDeclarationsFlag = new ThreadLocal();

    private ScriptSupportUtil() {
    }

    public static void clearCaches(XmlFile element) {
        element.putUserData(CachedScriptTagsKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processDeclarations(final XmlFile element, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        CachedValue<XmlTag[]> myCachedScriptTags = element.getUserData(CachedScriptTagsKey);
        if (myCachedScriptTags == null) {
            myCachedScriptTags = CachedValuesManager.getManager(element.getProject()).createCachedValue(new CachedValueProvider<XmlTag[]>(){

                @Override
                public CachedValueProvider.Result<XmlTag[]> compute() {
                    final ArrayList scriptTags = new ArrayList();
                    XmlDocument document = HtmlPsiUtil.getRealXmlDocument(element.getDocument());
                    if (document != null) {
                        PsiElementProcessor psiElementProcessor = new PsiElementProcessor(){

                            public boolean execute(@NotNull PsiElement element) {
                                XmlElementDescriptor descriptor;
                                XmlTag tag;
                                if (element == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/html/ScriptSupportUtil$1$1", "execute"));
                                }
                                if (element instanceof XmlTag && "script".equalsIgnoreCase((tag = (XmlTag)element).getName()) && (descriptor = tag.getDescriptor()) != null && "script".equals(descriptor.getName())) {
                                    scriptTags.add(tag);
                                }
                                return true;
                            }
                        };
                        XmlPsiUtil.processXmlElements(document, psiElementProcessor, true);
                    }
                    return new CachedValueProvider.Result<XmlTag[]>(scriptTags.toArray(new XmlTag[scriptTags.size()]), element);
                }
            }, false);
            element.putUserData(CachedScriptTagsKey, myCachedScriptTags);
        }
        if (ProcessingDeclarationsFlag.get() != null) {
            return true;
        }
        try {
            ProcessingDeclarationsFlag.set("");
            for (XmlTag tag : myCachedScriptTags.getValue()) {
                PsiFile psiFile;
                XmlAttribute attribute;
                XmlTagChild[] children;
                for (XmlTagChild child : children = tag.getValue().getChildren()) {
                    if (child.processDeclarations(processor, state, null, place)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (tag.getAttributeValue("src") == null || (attribute = tag.getAttribute("src", null)) == null || (psiFile = FileReferenceUtil.findFile(attribute.getValueElement())) == null || !psiFile.isValid() || psiFile.processDeclarations(processor, state, null, place)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            ProcessingDeclarationsFlag.set(null);
        }
        return true;
    }
}

