/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class InstanceofCatchParameterInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instanceof.catch.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/InstanceofCatchParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instanceof.catch.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/InstanceofCatchParameterInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofCatchParameterVisitor();
    }

    private static class InstanceofCatchParameterVisitor
    extends BaseInspectionVisitor {
        private InstanceofCatchParameterVisitor() {
        }

        @Override
        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression exp) {
            if (exp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/siyeh/ig/errorhandling/InstanceofCatchParameterInspection$InstanceofCatchParameterVisitor", "visitInstanceOfExpression"));
            }
            super.visitInstanceOfExpression(exp);
            if (!ControlFlowUtils.isInCatchBlock(exp)) {
                return;
            }
            PsiExpression operand = exp.getOperand();
            if (!(operand instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)operand;
            PsiElement referent = ref.resolve();
            if (!(referent instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)referent;
            if (!(parameter.getDeclarationScope() instanceof PsiCatchSection)) {
                return;
            }
            this.registerError((PsiElement)exp, new Object[0]);
        }
    }
}

