/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PlaceholderCountMatchesArgumentCountInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> loggingMethodNames = ContainerUtilRt.newHashSet("trace", "debug", "info", "warn", "error");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/PlaceholderCountMatchesArgumentCountInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer argumentCount = (Integer)infos[0];
        Integer placeholderCount = (Integer)infos[1];
        Object value = infos[2];
        if (argumentCount > placeholderCount) {
            String string = InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.more.problem.descriptor", argumentCount, placeholderCount, value);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/PlaceholderCountMatchesArgumentCountInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.fewer.problem.descriptor", argumentCount, placeholderCount, value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/PlaceholderCountMatchesArgumentCountInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PlaceholderCountMatchesArgumentCountVisitor();
    }

    private static class PlaceholderCountMatchesArgumentCountVisitor
    extends BaseInspectionVisitor {
        private PlaceholderCountMatchesArgumentCountVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            int argumentCount;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!loggingMethodNames.contains(name)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor(aClass, "org.slf4j.Logger")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression logStringArgument = arguments[0];
            if (InheritanceUtil.isInheritor(logStringArgument.getType(), "org.slf4j.Marker")) {
                if (arguments.length < 2) {
                    return;
                }
                logStringArgument = arguments[1];
                argumentCount = PlaceholderCountMatchesArgumentCountVisitor.countArguments(arguments, 2);
            } else {
                argumentCount = PlaceholderCountMatchesArgumentCountVisitor.countArguments(arguments, 1);
            }
            Object value = ExpressionUtils.computeConstantExpression(logStringArgument);
            int placeholderCount = PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders(value);
            if (placeholderCount < 0 || argumentCount < 0 || placeholderCount == argumentCount) {
                return;
            }
            this.registerError((PsiElement)logStringArgument, argumentCount, placeholderCount, value);
        }

        private static boolean hasThrowableType(PsiExpression lastArgument) {
            PsiType type = lastArgument.getType();
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    if (InheritanceUtil.isInheritor(disjunction, "java.lang.Throwable")) continue;
                    return false;
                }
                return true;
            }
            return InheritanceUtil.isInheritor(type, "java.lang.Throwable");
        }

        public static int countPlaceholders(Object value) {
            if (!(value instanceof String)) {
                return -1;
            }
            String string = (String)value;
            int count = 0;
            int index = string.indexOf("{}");
            while (index >= 0) {
                if (index == 0 || string.charAt(index - 1) != '\\') {
                    ++count;
                }
                index = string.indexOf("{}", index + 1);
            }
            return count;
        }

        private static int countArguments(PsiExpression[] arguments, int countFrom) {
            PsiExpression argument;
            PsiType argumentType;
            if (arguments.length <= countFrom) {
                return 0;
            }
            int count = arguments.length - countFrom;
            if (count == 1 && (argumentType = (argument = arguments[countFrom]).getType()) instanceof PsiArrayType) {
                PsiNewExpression newExpression;
                PsiArrayInitializerExpression arrayInitializerExpression;
                if (argumentType.equalsToText("java.lang.Object[]") && argument instanceof PsiNewExpression && (arrayInitializerExpression = (newExpression = (PsiNewExpression)argument).getArrayInitializer()) != null) {
                    return arrayInitializerExpression.getInitializers().length;
                }
                return -1;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            return PlaceholderCountMatchesArgumentCountVisitor.hasThrowableType(lastArgument) ? count - 1 : count;
        }
    }
}

