/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressWrapper
extends AbstractProgressIndicatorBase
implements WrappedProgressIndicator,
StandardProgressIndicator {
    private final ProgressIndicator myOriginal;
    private final boolean myCheckCanceledForMe;

    protected ProgressWrapper(@NotNull ProgressIndicator original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/progress/util/ProgressWrapper", "<init>"));
        }
        this(original, false);
    }

    protected ProgressWrapper(@NotNull ProgressIndicator original, boolean checkCanceledForMe) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/progress/util/ProgressWrapper", "<init>"));
        }
        this.myOriginal = original;
        this.myCheckCanceledForMe = checkCanceledForMe;
    }

    @Override
    public final void cancel() {
        super.cancel();
    }

    @Override
    public final boolean isCanceled() {
        return this.myOriginal.isCanceled() || this.myCheckCanceledForMe && super.isCanceled();
    }

    @Override
    public final void checkCanceled() {
        this.myOriginal.checkCanceled();
        super.checkCanceled();
    }

    @Override
    @NotNull
    public ProgressIndicator getOriginalProgressIndicator() {
        ProgressIndicator progressIndicator = this.myOriginal;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWrapper", "getOriginalProgressIndicator"));
        }
        return progressIndicator;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ProgressWrapper wrap(@Nullable ProgressIndicator indicator) {
        return indicator == null || indicator instanceof ProgressWrapper ? (ProgressWrapper)indicator : new ProgressWrapper(indicator);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ProgressIndicator unwrap(ProgressIndicator indicator) {
        return indicator instanceof ProgressWrapper ? ((ProgressWrapper)indicator).getOriginalProgressIndicator() : indicator;
    }
}

