/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CoreJarFileSystem
extends DeprecatedVirtualFileSystem {
    private final Map<String, CoreJarHandler> myHandlers = new HashMap<String, CoreJarHandler>();

    @Override
    @NotNull
    public String getProtocol() {
        if ("jar" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "getProtocol"));
        }
        return "jar";
    }

    @Override
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "findFileByPath"));
        }
        Couple<String> pair = this.splitPath(path);
        return this.getHandler((String)pair.first).findFileByPath((String)pair.second);
    }

    @NotNull
    protected Couple<String> splitPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "splitPath"));
        }
        int separator = path.indexOf("!/");
        if (separator < 0) {
            throw new IllegalArgumentException("Path in JarFileSystem must contain a separator: " + path);
        }
        String localPath = path.substring(0, separator);
        String pathInJar = path.substring(separator + 2);
        Couple<String> couple = Couple.of(localPath, pathInJar);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "splitPath"));
        }
        return couple;
    }

    @NotNull
    private CoreJarHandler getHandler(String localPath) {
        CoreJarHandler handler = this.myHandlers.get(localPath);
        if (handler == null) {
            handler = new CoreJarHandler(this, localPath);
            this.myHandlers.put(localPath, handler);
        }
        CoreJarHandler coreJarHandler = handler;
        if (coreJarHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "getHandler"));
        }
        return coreJarHandler;
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }

    @Override
    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "deleteFile"));
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    protected void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "moveFile"));
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "renameFile"));
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    @NotNull
    protected VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "createChildFile"));
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    @NotNull
    protected VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "createChildDirectory"));
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    @NotNull
    protected VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "copyFile"));
        }
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }
}

