/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.VisibilityUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefJavaUtilImpl
extends RefJavaUtil {
    @Override
    public void addReferences(final @NotNull PsiModifierListOwner psiFrom, @NotNull RefJavaElement ref, @Nullable PsiElement findIn) {
        if (psiFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFrom", "com/intellij/codeInspection/reference/RefJavaUtilImpl", "addReferences"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInspection/reference/RefJavaUtilImpl", "addReferences"));
        }
        final RefJavaElementImpl refFrom = (RefJavaElementImpl)ref;
        if (findIn == null) {
            return;
        }
        findIn.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement target = reference.resolve();
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference(aClass);
                    refFrom.addReference(refClass, aClass, psiFrom, false, true, null);
                }
                if (target instanceof PsiModifierListOwner && RefJavaUtil.isDeprecated(target)) {
                    refFrom.setUsesDeprecatedApi(true);
                }
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement(expression);
                PsiElement psiResolved = expression.resolve();
                if (psiResolved instanceof PsiModifierListOwner && RefJavaUtil.isDeprecated(psiResolved)) {
                    refFrom.setUsesDeprecatedApi(true);
                }
                RefElement refResolved = refFrom.getRefManager().getReference(psiResolved);
                refFrom.addReference(refResolved, psiResolved, psiFrom, PsiUtil.isAccessedForWriting(expression), PsiUtil.isAccessedForReading(expression), expression);
                if (refResolved instanceof RefMethod) {
                    RefJavaUtilImpl.this.updateRefMethod(psiResolved, refResolved, expression, psiFrom, refFrom);
                }
            }

            @Override
            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                super.visitEnumConstant(enumConstant);
                this.processNewLikeConstruct(enumConstant.resolveConstructor(), enumConstant.getArgumentList());
            }

            @Override
            public void visitNewExpression(PsiNewExpression newExpr) {
                PsiType newType;
                super.visitNewExpression(newExpr);
                PsiMethod psiConstructor = newExpr.resolveConstructor();
                PsiExpressionList argumentList = newExpr.getArgumentList();
                RefMethod refConstructor = this.processNewLikeConstruct(psiConstructor, argumentList);
                if (refConstructor == null && (newType = newExpr.getType()) instanceof PsiClassType) {
                    this.processClassReference(PsiUtil.resolveClassInType(newType), refFrom, psiFrom, true);
                }
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
                super.visitLambdaExpression(expression);
                this.processFunctionalExpression(expression);
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                super.visitMethodReferenceExpression(expression);
                this.processFunctionalExpression(expression);
            }

            private void processFunctionalExpression(PsiFunctionalExpression expression) {
                PsiClass aClass = PsiUtil.resolveClassInType(expression.getFunctionalInterfaceType());
                if (aClass != null) {
                    refFrom.addReference(refFrom.getRefManager().getReference(aClass), aClass, psiFrom, false, true, null);
                    PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(aClass);
                    if (interfaceMethod != null) {
                        refFrom.addReference(refFrom.getRefManager().getReference(interfaceMethod), interfaceMethod, psiFrom, false, true, null);
                        PsiElement body = null;
                        PsiElement topElement = null;
                        if (expression instanceof PsiLambdaExpression) {
                            body = ((PsiLambdaExpression)expression).getBody();
                            topElement = expression;
                        } else {
                            PsiElement resolve = ((PsiMethodReferenceExpression)expression).resolve();
                            if (resolve instanceof PsiMethod) {
                                body = ((PsiMethod)resolve).getBody();
                                topElement = resolve;
                            }
                        }
                        List<PsiClassType> exceptionTypes = body != null ? ExceptionUtil.collectUnhandledExceptions(body, topElement, false) : Collections.emptyList();
                        RefElement refResolved = refFrom.getRefManager().getReference(interfaceMethod);
                        if (refResolved instanceof RefMethodImpl) {
                            for (PsiClassType exceptionType : exceptionTypes) {
                                ((RefMethodImpl)refResolved).updateThrowsList(exceptionType);
                            }
                        }
                    }
                }
            }

            @Nullable
            private RefMethod processNewLikeConstruct(PsiMethod psiConstructor, PsiExpressionList argumentList) {
                if (psiConstructor != null && RefJavaUtil.isDeprecated(psiConstructor)) {
                    refFrom.setUsesDeprecatedApi(true);
                }
                RefMethodImpl refConstructor = (RefMethodImpl)refFrom.getRefManager().getReference(psiConstructor);
                refFrom.addReference(refConstructor, psiConstructor, psiFrom, false, true, null);
                if (argumentList != null) {
                    PsiExpression[] psiParams;
                    for (PsiExpression param : psiParams = argumentList.getExpressions()) {
                        param.accept(this);
                    }
                    if (refConstructor != null) {
                        refConstructor.updateParameterValues(psiParams);
                    }
                }
                return refConstructor;
            }

            @Override
            public void visitClass(PsiClass psiClass) {
                super.visitClass(psiClass);
                RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference(psiClass);
                refFrom.addReference(refClass, psiClass, psiFrom, false, true, null);
            }

            @Override
            public void visitReturnStatement(PsiReturnStatement statement) {
                super.visitReturnStatement(statement);
                if (refFrom instanceof RefMethodImpl) {
                    RefMethodImpl refMethod = (RefMethodImpl)refFrom;
                    refMethod.updateReturnValueTemplate(statement.getReturnValue());
                }
            }

            @Override
            public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
                super.visitClassObjectAccessExpression(expression);
                PsiTypeElement operand = expression.getOperand();
                PsiType type = operand.getType();
                if (type instanceof PsiClassType) {
                    this.processClassReference(((PsiClassType)type).resolve(), refFrom, psiFrom, false);
                }
            }

            private void processClassReference(PsiClass psiClass, RefJavaElementImpl refFrom2, PsiModifierListOwner psiFrom2, boolean defaultConstructorOnly) {
                RefClassImpl refClass;
                if (psiClass != null && (refClass = (RefClassImpl)refFrom2.getRefManager().getReference(psiClass)) != null) {
                    boolean hasConstructorsMarked = false;
                    if (defaultConstructorOnly) {
                        RefMethodImpl refDefaultConstructor = (RefMethodImpl)refClass.getDefaultConstructor();
                        if (refDefaultConstructor != null && !(refDefaultConstructor instanceof RefImplicitConstructor)) {
                            refDefaultConstructor.addInReference(refFrom2);
                            refFrom2.addOutReference(refDefaultConstructor);
                            hasConstructorsMarked = true;
                        }
                    } else {
                        for (RefMethod cons : refClass.getConstructors()) {
                            if (cons instanceof RefImplicitConstructor) continue;
                            ((RefMethodImpl)cons).addInReference(refFrom2);
                            refFrom2.addOutReference(cons);
                            hasConstructorsMarked = true;
                        }
                    }
                    if (!hasConstructorsMarked) {
                        refFrom2.addReference(refClass, psiClass, psiFrom2, false, true, null);
                    }
                }
            }
        });
    }

    private void updateRefMethod(PsiElement psiResolved, RefElement refResolved, PsiElement refExpression, PsiElement psiFrom, RefElement refFrom) {
        PsiMethod psiMethod = (PsiMethod)psiResolved;
        RefMethodImpl refMethod = (RefMethodImpl)refResolved;
        if (refExpression instanceof PsiMethodReferenceExpression) {
            PsiType returnType = psiMethod.getReturnType();
            if (!psiMethod.isConstructor() && returnType != PsiType.VOID) {
                refMethod.setReturnValueUsed(true);
                this.addTypeReference(psiFrom, returnType, refFrom.getRefManager());
            }
            return;
        }
        PsiMethodCallExpression call = PsiTreeUtil.getParentOfType(refExpression, PsiMethodCallExpression.class);
        if (call != null) {
            PsiClassType methodOwnerType;
            String fqName;
            PsiType usedType;
            PsiExpression psiExpression;
            PsiExpressionList argumentList;
            PsiType returnType = psiMethod.getReturnType();
            if (!psiMethod.isConstructor() && returnType != PsiType.VOID) {
                if (!(call.getParent() instanceof PsiExpressionStatement)) {
                    refMethod.setReturnValueUsed(true);
                }
                this.addTypeReference(psiFrom, returnType, refFrom.getRefManager());
            }
            if ((argumentList = call.getArgumentList()).getExpressions().length > 0) {
                refMethod.updateParameterValues(argumentList.getExpressions());
            }
            if ((psiExpression = call.getMethodExpression().getQualifierExpression()) != null && (usedType = psiExpression.getType()) != null && (fqName = psiMethod.getContainingClass().getQualifiedName()) != null && !usedType.equals(methodOwnerType = JavaPsiFacade.getInstance(call.getProject()).getElementFactory().createTypeByFQClassName(fqName, GlobalSearchScope.allScope(psiMethod.getProject())))) {
                refMethod.setCalledOnSubClass(true);
            }
        }
    }

    @Override
    public RefClass getTopLevelClass(@NotNull RefElement refElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/reference/RefJavaUtilImpl", "getTopLevelClass"));
        }
        for (RefEntity refParent = refElement.getOwner(); refParent != null && refParent instanceof RefElement && !(refParent instanceof RefFile); refParent = refParent.getOwner()) {
            refElement = (RefElementImpl)refParent;
        }
        return refElement instanceof RefClass ? (RefClass)refElement : null;
    }

    @Override
    public boolean isInheritor(@NotNull RefClass subClass, RefClass superClass) {
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/codeInspection/reference/RefJavaUtilImpl", "isInheritor"));
        }
        if (subClass == superClass) {
            return true;
        }
        for (RefClass baseClass : subClass.getBaseClasses()) {
            if (!this.isInheritor(baseClass, superClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getPackageName(RefEntity refEntity) {
        if (refEntity instanceof RefProject) {
            return null;
        }
        RefPackage refPackage = RefJavaUtilImpl.getPackage(refEntity);
        return refPackage == null ? InspectionsBundle.message("inspection.reference.default.package", new Object[0]) : refPackage.getQualifiedName();
    }

    @Override
    @NotNull
    public String getAccessModifier(@NotNull PsiModifierListOwner psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/reference/RefJavaUtilImpl", "getAccessModifier"));
        }
        if (psiElement instanceof PsiParameter) {
            if ("packageLocal" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaUtilImpl", "getAccessModifier"));
            }
            return "packageLocal";
        }
        PsiModifierList list = psiElement.getModifierList();
        String result = "packageLocal";
        if (list != null) {
            if (list.hasModifierProperty("private")) {
                result = "private";
            } else if (list.hasModifierProperty("protected")) {
                result = "protected";
            } else if (list.hasModifierProperty("public")) {
                result = "public";
            } else if (psiElement.getParent() instanceof PsiClass) {
                PsiClass ownerClass = (PsiClass)psiElement.getParent();
                if (ownerClass.isInterface()) {
                    result = "public";
                }
                if (ownerClass.isEnum() && result.equals("packageLocal")) {
                    result = "private";
                }
            }
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaUtilImpl", "getAccessModifier"));
        }
        return string;
    }

    @Override
    @Nullable
    public RefClass getOwnerClass(RefManager refManager, PsiElement psiElement) {
        while (psiElement != null && !(psiElement instanceof PsiClass)) {
            psiElement = psiElement.getParent();
        }
        return psiElement != null ? (RefClass)refManager.getReference(psiElement) : null;
    }

    @Override
    @Nullable
    public RefClass getOwnerClass(RefElement refElement) {
        RefEntity parent = refElement.getOwner();
        while (!(parent instanceof RefClass) && parent instanceof RefElement) {
            parent = parent.getOwner();
        }
        if (parent instanceof RefClass) {
            return (RefClass)parent;
        }
        return null;
    }

    @Override
    public boolean isMethodOnlyCallsSuper(PsiMethod method) {
        boolean hasStatements = false;
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            PsiStatement[] statements = body.getStatements();
            for (PsiElement psiElement : statements) {
                boolean isCallToSameSuper = false;
                if (psiElement instanceof PsiExpressionStatement) {
                    isCallToSameSuper = this.isCallToSuperMethod(((PsiExpressionStatement)psiElement).getExpression(), method);
                } else if (psiElement instanceof PsiReturnStatement) {
                    PsiExpression expression = ((PsiReturnStatement)psiElement).getReturnValue();
                    isCallToSameSuper = expression == null || this.isCallToSuperMethod(expression, method);
                }
                hasStatements = true;
                if (isCallToSameSuper) continue;
                return false;
            }
        }
        if (hasStatements) {
            PsiMethod[] superMethods = method.findSuperMethods();
            for (PsiElement psiElement : superMethods) {
                if (VisibilityUtil.compare(VisibilityUtil.getVisibilityModifier(psiElement.getModifierList()), VisibilityUtil.getVisibilityModifier(method.getModifierList())) <= 0) continue;
                return false;
            }
        }
        return hasStatements;
    }

    @Override
    public boolean isCallToSuperMethod(PsiExpression expression, PsiMethod method) {
        PsiMethodCallExpression methodCall;
        if (expression instanceof PsiMethodCallExpression && (methodCall = (PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression() instanceof PsiSuperExpression) {
            PsiMethod superMethod = (PsiMethod)methodCall.getMethodExpression().resolve();
            if (superMethod == null || !MethodSignatureUtil.areSignaturesEqual(method, superMethod)) {
                return false;
            }
            PsiExpression[] args = methodCall.getArgumentList().getExpressions();
            PsiParameter[] parms = method.getParameterList().getParameters();
            for (int i = 0; i < args.length; ++i) {
                PsiExpression arg = args[i];
                if (!(arg instanceof PsiReferenceExpression)) {
                    return false;
                }
                if (parms[i].equals(((PsiReferenceExpression)arg).resolve())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareAccess(String a1, String a2) {
        int i2;
        int i1 = RefJavaUtilImpl.getAccessNumber(a1);
        if (i1 == (i2 = RefJavaUtilImpl.getAccessNumber(a2))) {
            return 0;
        }
        if (i1 < i2) {
            return -1;
        }
        return 1;
    }

    private static int getAccessNumber(String a) {
        if (a == "private") {
            return 0;
        }
        if (a == "packageLocal") {
            return 1;
        }
        if (a == "protected") {
            return 2;
        }
        if (a == "public") {
            return 3;
        }
        return -1;
    }

    @Override
    public void setAccessModifier(@NotNull RefJavaElement refElement, @NotNull String newAccess) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/reference/RefJavaUtilImpl", "setAccessModifier"));
        }
        if (newAccess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newAccess", "com/intellij/codeInspection/reference/RefJavaUtilImpl", "setAccessModifier"));
        }
        ((RefJavaElementImpl)refElement).setAccessModifier(newAccess);
    }

    @Override
    public void setIsStatic(RefJavaElement refElement, boolean isStatic) {
        ((RefJavaElementImpl)refElement).setIsStatic(isStatic);
    }

    @Override
    public void setIsFinal(RefJavaElement refElement, boolean isFinal) {
        ((RefJavaElementImpl)refElement).setIsFinal(isFinal);
    }

    @Override
    public void addTypeReference(PsiElement psiElement, PsiType psiType, RefManager refManager) {
        RefClassImpl refClass;
        PsiClass psiClass;
        RefClass ownerClass = this.getOwnerClass(refManager, psiElement);
        if (ownerClass != null && (psiType = psiType.getDeepComponentType()) instanceof PsiClassType && (psiClass = PsiUtil.resolveClassInType(psiType)) != null && refManager.belongsToScope(psiClass) && (refClass = (RefClassImpl)refManager.getReference(psiClass)) != null) {
            refClass.addTypeReference(ownerClass);
        }
    }
}

