/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Map;

public class ExpandMacroToPathMap
extends PathMacroMap {
    private final Map<String, String> myPlainMap = ContainerUtilRt.newLinkedHashMap();
    private final Map<String, String> myMacroExpands = ContainerUtil.newHashMap();

    public void addMacroExpand(String macroName, String path) {
        this.myMacroExpands.put(macroName, PathMacroMap.quotePath(path));
    }

    public void put(String fromText, String toText) {
        this.myPlainMap.put(fromText, toText);
    }

    public void putAll(ExpandMacroToPathMap another) {
        this.myPlainMap.putAll(another.myPlainMap);
        this.myMacroExpands.putAll(another.myMacroExpands);
    }

    @Override
    public String substitute(String text, boolean caseSensitive) {
        if (text == null) {
            return null;
        }
        if (text.indexOf(36) < 0 && text.indexOf(37) < 0) {
            return text;
        }
        for (Map.Entry<String, String> entry : this.myPlainMap.entrySet()) {
            text = StringUtil.replace(text, entry.getKey(), entry.getValue(), false);
        }
        for (String macroName : this.myMacroExpands.keySet()) {
            text = ExpandMacroToPathMap.replaceMacro(text, macroName, this.myMacroExpands.get(macroName));
        }
        return text;
    }

    private static String replaceMacro(String text, String macroName, String replacement) {
        int start;
        while ((start = ExpandMacroToPathMap.findMacroIndex(text, macroName)) >= 0) {
            int end = start + macroName.length() + 2;
            int slashCount = ExpandMacroToPathMap.getSlashCount(text, end);
            String actualReplacement = slashCount > 0 && !replacement.endsWith("/") ? replacement + "/" : replacement;
            text = StringUtil.replaceSubstring(text, new TextRange(start, end + slashCount), actualReplacement);
        }
        return text;
    }

    private static int getSlashCount(String text, int pos) {
        return StringUtil.isChar(text, pos, '/') ? (StringUtil.isChar(text, pos + 1, '/') ? 2 : 1) : 0;
    }

    private static int findMacroIndex(String text, String macroName) {
        int i = -1;
        do {
            if ((i = text.indexOf(36, i + 1)) >= 0) continue;
            return -1;
        } while (!StringUtil.startsWith(text, i + 1, macroName) || !StringUtil.isChar(text, i + macroName.length() + 1, '$'));
        return i;
    }

    @Override
    public int hashCode() {
        return ((Object)this.myPlainMap).hashCode() + ((Object)this.myMacroExpands).hashCode();
    }
}

