/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class MainConfigurationStateSplitter
extends StateSplitterEx {
    @Override
    public final List<Pair<Element, String>> splitState(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/MainConfigurationStateSplitter", "splitState"));
        }
        UniqueNameGenerator generator = new UniqueNameGenerator();
        SmartList<Pair<Element, String>> result = new SmartList<Pair<Element, String>>();
        Iterator iterator = state.getChildren(this.getSubStateTagName()).iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            iterator.remove();
            result.add(MainConfigurationStateSplitter.createItem(this.getSubStateFileName(element), generator, element));
        }
        if (!JDOMUtil.isEmpty(state)) {
            result.add(MainConfigurationStateSplitter.createItem(this.getComponentStateFileName(), generator, state));
        }
        return result;
    }

    @Override
    public final void mergeStateInto(@NotNull Element target, @NotNull Element subState) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/openapi/components/MainConfigurationStateSplitter", "mergeStateInto"));
        }
        if (subState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subState", "com/intellij/openapi/components/MainConfigurationStateSplitter", "mergeStateInto"));
        }
        MainConfigurationStateSplitter.mergeStateInto(target, subState, this.getSubStateTagName());
    }

    @NotNull
    protected abstract String getSubStateFileName(@NotNull Element var1);

    @NotNull
    protected abstract String getComponentStateFileName();

    @NotNull
    protected abstract String getSubStateTagName();
}

