/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ConvertingIterator;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleLibraryTable
implements LibraryTable,
LibraryTableBase.ModifiableModelEx {
    private static final ModuleLibraryOrderEntryCondition MODULE_LIBRARY_ORDER_ENTRY_FILTER = new ModuleLibraryOrderEntryCondition();
    private static final OrderEntryToLibraryConvertor ORDER_ENTRY_TO_LIBRARY_CONVERTOR = new OrderEntryToLibraryConvertor();
    private final RootModelImpl myRootModel;
    private final ProjectRootManagerImpl myProjectRootManager;
    public static final LibraryTablePresentation MODULE_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

        @Override
        public String getDisplayName(boolean plural) {
            return ProjectBundle.message("module.library.display.name", plural ? 2 : 1);
        }

        @Override
        public String getDescription() {
            return ProjectBundle.message("libraries.node.text.module", new Object[0]);
        }

        @Override
        public String getLibraryTableEditorTitle() {
            return ProjectBundle.message("library.configure.module.title", new Object[0]);
        }
    };

    ModuleLibraryTable(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        this.myRootModel = rootModel;
        this.myProjectRootManager = projectRootManager;
    }

    @Override
    @NotNull
    public Library[] getLibraries() {
        ArrayList result = new ArrayList();
        Iterator<Library> libraryIterator = this.getLibraryIterator();
        ContainerUtil.addAll(result, libraryIterator);
        Library[] libraryArray = result.toArray(new Library[result.size()]);
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "getLibraries"));
        }
        return libraryArray;
    }

    @Override
    public Library createLibrary() {
        return this.createLibrary(null);
    }

    @Override
    public Library createLibrary(String name) {
        return this.createLibrary(name, null);
    }

    @Override
    public Library createLibrary(String name, @Nullable PersistentLibraryKind kind) {
        ModuleLibraryOrderEntryImpl orderEntry = new ModuleLibraryOrderEntryImpl(name, kind, this.myRootModel, this.myProjectRootManager);
        this.myRootModel.addOrderEntry(orderEntry);
        return orderEntry.getLibrary();
    }

    @Override
    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "removeLibrary"));
        }
        Iterator<OrderEntry> orderIterator = this.myRootModel.getOrderIterator();
        while (orderIterator.hasNext()) {
            LibraryOrderEntry libraryOrderEntry;
            OrderEntry orderEntry = orderIterator.next();
            if (!(orderEntry instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || !library.equals(libraryOrderEntry.getLibrary())) continue;
            this.myRootModel.removeOrderEntry(orderEntry);
            return;
        }
    }

    @Override
    @NotNull
    public Iterator<Library> getLibraryIterator() {
        FilteringIterator filteringIterator = new FilteringIterator(this.myRootModel.getOrderIterator(), MODULE_LIBRARY_ORDER_ENTRY_FILTER);
        ConvertingIterator<LibraryOrderEntry, Library> convertingIterator = new ConvertingIterator<LibraryOrderEntry, Library>(filteringIterator, ORDER_ENTRY_TO_LIBRARY_CONVERTOR);
        if (convertingIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "getLibraryIterator"));
        }
        return convertingIterator;
    }

    @Override
    public String getTableLevel() {
        return "module";
    }

    @Override
    public LibraryTablePresentation getPresentation() {
        return MODULE_LIBRARY_TABLE_PRESENTATION;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    @Nullable
    public Library getLibraryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/impl/ModuleLibraryTable", "getLibraryByName"));
        }
        Iterator<Library> libraryIterator = this.getLibraryIterator();
        while (libraryIterator.hasNext()) {
            Library library = libraryIterator.next();
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    @Override
    public void addListener(LibraryTable.Listener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(LibraryTable.Listener listener, Disposable parentDisposable) {
        throw new UnsupportedOperationException("Method addListener is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public void removeListener(LibraryTable.Listener listener) {
        throw new UnsupportedOperationException();
    }

    public Module getModule() {
        return this.myRootModel.getModule();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean isChanged() {
        return this.myRootModel.isChanged();
    }

    @Override
    public LibraryTable.ModifiableModel getModifiableModel() {
        return this;
    }

    private static class OrderEntryToLibraryConvertor
    implements Convertor<LibraryOrderEntry, Library> {
        private OrderEntryToLibraryConvertor() {
        }

        @Override
        public Library convert(LibraryOrderEntry o) {
            return o.getLibrary();
        }
    }

    private static class ModuleLibraryOrderEntryCondition
    implements Condition<OrderEntry> {
        private ModuleLibraryOrderEntryCondition() {
        }

        @Override
        public boolean value(OrderEntry entry) {
            return entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).isModuleLevel() && ((LibraryOrderEntry)entry).getLibrary() != null;
        }
    }
}

