/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class TestFrameworksImpl
extends TestFrameworks {
    private TestFrameworksImpl() {
    }

    @Override
    public boolean isTestClass(PsiClass psiClass) {
        TestFramework[] testFrameworks;
        for (TestFramework framework : testFrameworks = Extensions.getExtensions(TestFramework.EXTENSION_NAME)) {
            if (!framework.isTestClass(psiClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPotentialTestClass(PsiClass psiClass) {
        TestFramework[] testFrameworks;
        for (TestFramework framework : testFrameworks = Extensions.getExtensions(TestFramework.EXTENSION_NAME)) {
            if (!framework.isPotentialTestClass(psiClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PsiMethod findOrCreateSetUpMethod(PsiClass psiClass) {
        TestFramework[] testFrameworks;
        for (TestFramework framework : testFrameworks = Extensions.getExtensions(TestFramework.EXTENSION_NAME)) {
            if (!framework.isTestClass(psiClass)) continue;
            try {
                PsiMethod setUpMethod = (PsiMethod)framework.findOrCreateSetUpMethod(psiClass);
                if (setUpMethod == null) continue;
                return setUpMethod;
            }
            catch (IncorrectOperationException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiMethod findSetUpMethod(PsiClass psiClass) {
        TestFramework[] testFrameworks;
        for (TestFramework framework : testFrameworks = Extensions.getExtensions(TestFramework.EXTENSION_NAME)) {
            PsiMethod setUpMethod;
            if (!framework.isTestClass(psiClass) || (setUpMethod = (PsiMethod)framework.findSetUpMethod(psiClass)) == null) continue;
            return setUpMethod;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiMethod findTearDownMethod(PsiClass psiClass) {
        TestFramework[] testFrameworks;
        for (TestFramework framework : testFrameworks = Extensions.getExtensions(TestFramework.EXTENSION_NAME)) {
            PsiMethod setUpMethod;
            if (!framework.isTestClass(psiClass) || (setUpMethod = (PsiMethod)framework.findTearDownMethod(psiClass)) == null) continue;
            return setUpMethod;
        }
        return null;
    }

    @Override
    protected boolean hasConfigMethods(PsiClass psiClass) {
        TestFramework[] testFrameworks;
        for (TestFramework framework : testFrameworks = Extensions.getExtensions(TestFramework.EXTENSION_NAME)) {
            if (framework.findSetUpMethod(psiClass) == null && framework.findTearDownMethod(psiClass) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTestMethod(PsiMethod method) {
        TestFramework[] testFrameworks;
        for (TestFramework framework : testFrameworks = Extensions.getExtensions(TestFramework.EXTENSION_NAME)) {
            if (!framework.isTestMethod(method)) continue;
            return true;
        }
        return false;
    }
}

