/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryRuntimeClasspathScope
extends GlobalSearchScope {
    private final ProjectFileIndex myIndex;
    private final LinkedHashSet<VirtualFile> myEntries = new LinkedHashSet();
    private int myCachedHashCode = 0;

    public LibraryRuntimeClasspathScope(Project project, List<Module> modules) {
        super(project);
        this.myIndex = ProjectRootManager.getInstance(project).getFileIndex();
        THashSet processedSdk = new THashSet();
        THashSet processedLibraries = new THashSet();
        THashSet processedModules = new THashSet();
        Condition<OrderEntry> condition = new Condition<OrderEntry>((Set)processedModules){
            final /* synthetic */ Set val$processedModules;
            {
                this.val$processedModules = set;
            }

            @Override
            public boolean value(OrderEntry orderEntry) {
                if (orderEntry instanceof ModuleOrderEntry) {
                    Module module = ((ModuleOrderEntry)orderEntry).getModule();
                    return module != null && !this.val$processedModules.contains(module);
                }
                return true;
            }
        };
        for (Module module : modules) {
            this.buildEntries(module, (Set<Module>)processedModules, (Set<Library>)processedLibraries, (Set<Sdk>)processedSdk, condition);
        }
    }

    public LibraryRuntimeClasspathScope(Project project, LibraryOrderEntry entry) {
        super(project);
        this.myIndex = ProjectRootManager.getInstance(project).getFileIndex();
        Collections.addAll(this.myEntries, entry.getRootFiles(OrderRootType.CLASSES));
    }

    @Override
    public int hashCode() {
        if (this.myCachedHashCode == 0) {
            this.myCachedHashCode = this.myEntries.hashCode();
        }
        return this.myCachedHashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != LibraryRuntimeClasspathScope.class) {
            return false;
        }
        LibraryRuntimeClasspathScope that = (LibraryRuntimeClasspathScope)object;
        return that.myEntries.equals(this.myEntries);
    }

    private void buildEntries(@NotNull Module module, final @NotNull Set<Module> processedModules, final @NotNull Set<Library> processedLibraries, final @NotNull Set<Sdk> processedSdk, Condition<OrderEntry> condition) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "buildEntries"));
        }
        if (processedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedModules", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "buildEntries"));
        }
        if (processedLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedLibraries", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "buildEntries"));
        }
        if (processedSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedSdk", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "buildEntries"));
        }
        if (!processedModules.add(module)) {
            return;
        }
        ModuleRootManager.getInstance(module).orderEntries().recursively().satisfying(condition).process(new RootPolicy<LinkedHashSet<VirtualFile>>(){

            @Override
            public LinkedHashSet<VirtualFile> visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, LinkedHashSet<VirtualFile> value) {
                Library library = libraryOrderEntry.getLibrary();
                if (library != null && processedLibraries.add(library)) {
                    ContainerUtil.addAll(value, libraryOrderEntry.getRootFiles(OrderRootType.CLASSES));
                }
                return value;
            }

            @Override
            public LinkedHashSet<VirtualFile> visitModuleSourceOrderEntry(ModuleSourceOrderEntry moduleSourceOrderEntry, LinkedHashSet<VirtualFile> value) {
                processedModules.add(moduleSourceOrderEntry.getOwnerModule());
                ContainerUtil.addAll(value, moduleSourceOrderEntry.getRootModel().getSourceRoots());
                return value;
            }

            @Override
            public LinkedHashSet<VirtualFile> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, LinkedHashSet<VirtualFile> value) {
                Module depModule = moduleOrderEntry.getModule();
                if (depModule != null) {
                    ContainerUtil.addAll(value, ModuleRootManager.getInstance(depModule).getSourceRoots());
                }
                return value;
            }

            @Override
            public LinkedHashSet<VirtualFile> visitJdkOrderEntry(JdkOrderEntry jdkOrderEntry, LinkedHashSet<VirtualFile> value) {
                Sdk jdk = jdkOrderEntry.getJdk();
                if (jdk != null && processedSdk.add(jdk)) {
                    ContainerUtil.addAll(value, jdkOrderEntry.getRootFiles(OrderRootType.CLASSES));
                }
                return value;
            }
        }, this.myEntries);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "contains"));
        }
        return this.myEntries.contains(this.getFileRoot(file));
    }

    @Nullable
    private VirtualFile getFileRoot(VirtualFile file) {
        if (this.myIndex.isLibraryClassFile(file)) {
            return this.myIndex.getClassRootForFile(file);
        }
        if (this.myIndex.isInContent(file)) {
            return this.myIndex.getSourceRootForFile(file);
        }
        if (this.myIndex.isInLibraryClasses(file)) {
            return this.myIndex.getClassRootForFile(file);
        }
        return null;
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "compare"));
        }
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        for (VirtualFile root : this.myEntries) {
            if (Comparing.equal(r1, root)) {
                return 1;
            }
            if (!Comparing.equal(r2, root)) continue;
            return -1;
        }
        return 0;
    }

    public List<VirtualFile> getRoots() {
        return new ArrayList<VirtualFile>(this.myEntries);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "isSearchInModuleContent"));
        }
        return false;
    }

    @Override
    public boolean isSearchInLibraries() {
        return true;
    }
}

