/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class AllClassesSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create("com.intellij.allClassesSearch");
    public static final AllClassesSearch INSTANCE = new AllClassesSearch();

    @NotNull
    public static Query<PsiClass> search(@NotNull SearchScope scope, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AllClassesSearch", "search"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/searches/AllClassesSearch", "search"));
        }
        Query<PsiClass> query = INSTANCE.createQuery(new SearchParameters(scope, project));
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/AllClassesSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull SearchScope scope, @NotNull Project project, @NotNull Condition<String> shortNameCondition) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AllClassesSearch", "search"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/searches/AllClassesSearch", "search"));
        }
        if (shortNameCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNameCondition", "com/intellij/psi/search/searches/AllClassesSearch", "search"));
        }
        Query<PsiClass> query = INSTANCE.createQuery(new SearchParameters(scope, project, shortNameCondition));
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/AllClassesSearch", "search"));
        }
        return query;
    }

    public static class SearchParameters {
        private final SearchScope myScope;
        private final Project myProject;
        private final Condition<String> myShortNameCondition;

        public SearchParameters(@NotNull SearchScope scope, @NotNull Project project) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AllClassesSearch$SearchParameters", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/searches/AllClassesSearch$SearchParameters", "<init>"));
            }
            this(scope, project, Conditions.alwaysTrue());
        }

        public SearchParameters(@NotNull SearchScope scope, @NotNull Project project, @NotNull Condition<String> shortNameCondition) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AllClassesSearch$SearchParameters", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/searches/AllClassesSearch$SearchParameters", "<init>"));
            }
            if (shortNameCondition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNameCondition", "com/intellij/psi/search/searches/AllClassesSearch$SearchParameters", "<init>"));
            }
            this.myScope = scope;
            this.myProject = project;
            this.myShortNameCondition = shortNameCondition;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/AllClassesSearch$SearchParameters", "getScope"));
            }
            return searchScope;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/AllClassesSearch$SearchParameters", "getProject"));
            }
            return project;
        }

        public boolean nameMatches(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/searches/AllClassesSearch$SearchParameters", "nameMatches"));
            }
            return this.myShortNameCondition.value(name);
        }
    }
}

