/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.finalization.CallToSuperFinalizeVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FinalizeCallsSuperFinalizeInspection
extends BaseInspection {
    public boolean ignoreObjectSubclasses = false;
    public boolean ignoreTrivialFinalizers = true;

    @Override
    @NotNull
    public String getID() {
        if ("FinalizeDoesntCallSuperFinalize" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeCallsSuperFinalizeInspection", "getID"));
        }
        return "FinalizeDoesntCallSuperFinalize";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("finalize.doesnt.call.super.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeCallsSuperFinalizeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("finalize.doesnt.call.super.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeCallsSuperFinalizeInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("finalize.doesnt.call.super.ignore.option", new Object[0]), "ignoreObjectSubclasses");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("ignore.trivial.finalizers.option", new Object[0]), "ignoreTrivialFinalizers");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NoExplicitFinalizeCallsVisitor();
    }

    private class NoExplicitFinalizeCallsVisitor
    extends BaseInspectionVisitor {
        private NoExplicitFinalizeCallsVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            String superClassName;
            PsiClass superClass;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/finalization/FinalizeCallsSuperFinalizeInspection$NoExplicitFinalizeCallsVisitor", "visitMethod"));
            }
            String methodName = method.getName();
            if (!"finalize".equals(methodName)) {
                return;
            }
            if (method.hasModifierProperty("native") || method.hasModifierProperty("abstract")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (FinalizeCallsSuperFinalizeInspection.this.ignoreObjectSubclasses && (superClass = containingClass.getSuperClass()) != null && "java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            CallToSuperFinalizeVisitor visitor = new CallToSuperFinalizeVisitor();
            method.accept(visitor);
            if (visitor.isCallToSuperFinalizeFound()) {
                return;
            }
            if (FinalizeCallsSuperFinalizeInspection.this.ignoreTrivialFinalizers && this.isTrivial(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean isTrivial(PsiMethod method) {
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return true;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return true;
            }
            Project project = method.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiConstantEvaluationHelper evaluationHelper = psiFacade.getConstantEvaluationHelper();
            for (PsiStatement statement : statements) {
                if (!(statement instanceof PsiIfStatement)) {
                    return false;
                }
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiExpression condition = ifStatement.getCondition();
                Object result = evaluationHelper.computeConstantExpression(condition);
                if (result != null && result.equals(Boolean.FALSE)) continue;
                return false;
            }
            return true;
        }
    }
}

