/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StringConcatenationInLoopsInspection
extends BaseInspection {
    public boolean m_ignoreUnlessAssigned = true;

    @Override
    @NotNull
    public String getID() {
        if ("StringContatenationInLoop" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "getID"));
        }
        return "StringContatenationInLoop";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.concatenation.in.loops.only.option", new Object[0]), this, "m_ignoreUnlessAssigned");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInLoopsVisitor();
    }

    private class StringConcatenationInLoopsVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInLoopsVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            PsiExpression[] operands = expression.getOperands();
            if (operands.length <= 1) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUS)) {
                return;
            }
            PsiType type = expression.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            if (!ControlFlowUtils.isInLoop(expression)) {
                return;
            }
            if (ControlFlowUtils.isInExitStatement(expression)) {
                return;
            }
            if (ExpressionUtils.isEvaluatedAtCompileTime(expression)) {
                return;
            }
            if (this.containingStatementExits(expression)) {
                return;
            }
            if (StringConcatenationInLoopsInspection.this.m_ignoreUnlessAssigned && !this.isAppendedRepeatedly(expression)) {
                return;
            }
            PsiJavaToken sign = expression.getTokenBeforeOperand(operands[1]);
            this.registerError((PsiElement)sign, new Object[0]);
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$StringConcatenationInLoopsVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression);
            if (expression.getRExpression() == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSEQ)) {
                return;
            }
            PsiExpression lhs = expression.getLExpression();
            PsiType type = lhs.getType();
            if (type == null) {
                return;
            }
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            if (!ControlFlowUtils.isInLoop(expression)) {
                return;
            }
            if (ControlFlowUtils.isInExitStatement(expression)) {
                return;
            }
            if (this.containingStatementExits(expression)) {
                return;
            }
            if (StringConcatenationInLoopsInspection.this.m_ignoreUnlessAssigned) {
                while (lhs instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)lhs;
                    lhs = parenthesizedExpression.getExpression();
                }
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
            }
            this.registerError((PsiElement)sign, new Object[0]);
        }

        private boolean containingStatementExits(PsiElement element) {
            PsiStatement newExpressionStatement = PsiTreeUtil.getParentOfType(element, PsiStatement.class);
            if (newExpressionStatement == null) {
                return this.containingStatementExits(element);
            }
            PsiStatement parentStatement = PsiTreeUtil.getParentOfType((PsiElement)newExpressionStatement, PsiStatement.class);
            return !ControlFlowUtils.statementMayCompleteNormally(parentStatement);
        }

        private boolean isAppendedRepeatedly(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            while (lhs instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)lhs;
                lhs = parenthesizedExpression.getExpression();
            }
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            if (assignmentExpression.getOperationTokenType() == JavaTokenType.PLUSEQ) {
                return true;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)element;
            PsiExpression rhs = assignmentExpression.getRExpression();
            return rhs != null && VariableAccessUtils.variableIsUsed(variable, rhs);
        }
    }
}

