/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFileDeleteEvent
extends VFileEvent {
    @NotNull
    private final VirtualFile myFile;
    private int myDepth;

    public VFileDeleteEvent(@Nullable Object requestor, @NotNull VirtualFile file, boolean isFromRefresh) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/events/VFileDeleteEvent", "<init>"));
        }
        super(requestor, isFromRefresh);
        this.myDepth = -1;
        this.myFile = file;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileDeleteEvent", "getFile"));
        }
        return virtualFile;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[deleted: " + this.myFile.getUrl() + "]";
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myFile.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileDeleteEvent", "getPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileDeleteEvent", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileDeleteEvent event = (VFileDeleteEvent)o;
        return this.myFile.equals(event.myFile);
    }

    @Override
    public int hashCode() {
        return this.myFile.hashCode();
    }

    public int getFileDepth() {
        if (this.myDepth == -1) {
            int d = 0;
            for (VirtualFile cur = this.myFile; cur != null; cur = cur.getParent()) {
                ++d;
            }
            this.myDepth = d;
        }
        return this.myDepth;
    }
}

