/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.extensions.PluginId;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class PluginClassCache {
    private static final Object ourLock = new Object();
    private final Map<String, PluginId> myMissingClasses = new THashMap();
    private final TObjectIntHashMap<PluginId> myClassCounts = new TObjectIntHashMap();

    PluginClassCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginClass(String className, PluginId pluginId, boolean loaded) {
        Object object = ourLock;
        synchronized (object) {
            if (loaded) {
                this.myMissingClasses.remove(className);
                this.myClassCounts.put((Object)pluginId, this.myClassCounts.get((Object)pluginId) + 1);
            } else {
                this.myMissingClasses.put(className, pluginId);
            }
        }
    }

    @Nullable
    private static PluginId findLoadingPlugin(String className) {
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            ClassLoader loader = descriptor.getPluginClassLoader();
            if (!(loader instanceof PluginClassLoader) || !((PluginClassLoader)loader).hasLoadedClass(className)) continue;
            return descriptor.getPluginId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpPluginClassStatistics() {
        ArrayList<Object> counters;
        if (!Boolean.valueOf(System.getProperty("idea.is.internal")).booleanValue()) {
            return;
        }
        Object object = ourLock;
        synchronized (object) {
            counters = new ArrayList<Object>(Arrays.asList(this.myClassCounts.keys()));
        }
        Collections.sort(counters, new Comparator<PluginId>(){

            @Override
            public int compare(PluginId o1, PluginId o2) {
                return PluginClassCache.this.myClassCounts.get((Object)o2) - PluginClassCache.this.myClassCounts.get((Object)o1);
            }
        });
        for (PluginId pluginId : counters) {
            PluginManagerCore.getLogger().info(pluginId + " loaded " + this.myClassCounts.get((Object)pluginId) + " classes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PluginId getPluginByClassName(String className) {
        Object object = ourLock;
        synchronized (object) {
            PluginId id = this.myMissingClasses.get(className);
            if (id != null) {
                return id;
            }
        }
        return PluginClassCache.findLoadingPlugin(className);
    }
}

