/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JavaProblemHighlightFilter
extends ProblemHighlightFilter {
    @Override
    public boolean shouldHighlight(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/JavaProblemHighlightFilter", "shouldHighlight"));
        }
        return psiFile.getFileType() != JavaFileType.INSTANCE || !JavaProjectRootsUtil.isOutsideJavaSourceRoot(psiFile);
    }

    @Override
    public boolean shouldProcessInBatch(@NotNull PsiFile psiFile) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/JavaProblemHighlightFilter", "shouldProcessInBatch"));
        }
        boolean shouldHighlight = JavaProblemHighlightFilter.shouldHighlightFile(psiFile);
        if (shouldHighlight && psiFile.getFileType() == JavaFileType.INSTANCE && (virtualFile = psiFile.getVirtualFile()) != null && ProjectRootManager.getInstance(psiFile.getProject()).getFileIndex().isInLibrarySource(virtualFile)) {
            return false;
        }
        return shouldHighlight;
    }
}

