/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class HTMLExporter {
    private final String myRootFolder;
    private int myFileCounter;
    private final Map<RefEntity, String> myElementToFilenameMap;
    private final HTMLComposerImpl myComposer;
    private final Set<RefEntity> myGeneratedReferences;
    private final Set<RefEntity> myGeneratedPages;

    public HTMLExporter(String rootFolder, HTMLComposerImpl composer) {
        this.myRootFolder = rootFolder;
        this.myElementToFilenameMap = new HashMap<RefEntity, String>();
        this.myFileCounter = 0;
        this.myComposer = composer;
        this.myGeneratedPages = new HashSet<RefEntity>();
        this.myGeneratedReferences = new HashSet<RefEntity>();
    }

    public void createPage(RefEntity element) throws IOException {
        String currentFileName = this.fileNameForElement(element);
        StringBuffer buf = new StringBuffer();
        this.appendNavBar(buf, element);
        this.myComposer.composeWithExporter(buf, element, this);
        HTMLExporter.writeFileImpl(this.myRootFolder, currentFileName, buf);
        this.myGeneratedPages.add(element);
    }

    private void appendNavBar(@NonNls StringBuffer buf, RefEntity element) {
        buf.append("<a href=\"../index.html\" target=\"_top\">");
        buf.append(InspectionsBundle.message("inspection.export.inspections.link.text", new Object[0]));
        buf.append("</a>  ");
        if (element instanceof RefElement) {
            this.myComposer.appendElementReference(buf, this.getURL(element), InspectionsBundle.message("inspection.export.open.source.link.text", new Object[0]), "_blank");
        }
        buf.append("<hr>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileImpl(String folder, @NonNls String fileName, CharSequence buf) throws IOException {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        String fullPath = folder + File.separator + fileName;
        if (indicator != null) {
            ProgressManager.checkCanceled();
            indicator.setText(InspectionsBundle.message("inspection.export.generating.html.for", fullPath));
        }
        OutputStreamWriter writer = null;
        try {
            File folderFile = new File(folder);
            folderFile.mkdirs();
            new File(fullPath).getParentFile().mkdirs();
            writer = new FileWriter(fullPath);
            writer.write(((Object)buf).toString().toCharArray());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getURL(RefEntity element) {
        this.myGeneratedReferences.add(element);
        return this.fileNameForElement(element);
    }

    private String fileNameForElement(RefEntity element) {
        String fileName = this.myElementToFilenameMap.get(element);
        if (fileName == null) {
            fileName = "e" + Integer.toString(++this.myFileCounter) + ".html";
            this.myElementToFilenameMap.put(element, fileName);
        }
        return fileName;
    }

    private Set<RefEntity> getReferencesWithoutPages() {
        HashSet<RefEntity> result = new HashSet<RefEntity>();
        for (RefEntity refElement : this.myGeneratedReferences) {
            if (this.myGeneratedPages.contains(refElement)) continue;
            result.add(refElement);
        }
        return result;
    }

    public void generateReferencedPages() throws IOException {
        Set<RefEntity> extras = this.getReferencesWithoutPages();
        while (extras.size() > 0) {
            for (RefEntity refElement : extras) {
                this.createPage(refElement);
            }
            extras = this.getReferencesWithoutPages();
        }
    }

    public String getRootFolder() {
        return this.myRootFolder;
    }
}

