/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelUtil
extends EffectiveLanguageLevelUtil {
    @NotNull
    public static LanguageLevel getLanguageLevelForFile(@Nullable VirtualFile file) {
        if (file == null) {
            LanguageLevel languageLevel = LanguageLevel.HIGHEST;
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/LanguageLevelUtil", "getLanguageLevelForFile"));
            }
            return languageLevel;
        }
        if (file.isDirectory()) {
            LanguageLevel languageLevel = file.getUserData(LanguageLevel.KEY);
            LanguageLevel languageLevel2 = languageLevel != null ? languageLevel : LanguageLevel.HIGHEST;
            if (languageLevel2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/LanguageLevelUtil", "getLanguageLevelForFile"));
            }
            return languageLevel2;
        }
        LanguageLevel languageLevel = LanguageLevelUtil.getLanguageLevelForFile(file.getParent());
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/LanguageLevelUtil", "getLanguageLevelForFile"));
        }
        return languageLevel;
    }
}

