/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryContinueInspection
extends BaseInspection {
    public boolean ignoreInThenBranch = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.continue.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryContinueInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.continue.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryContinueInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.return.option", new Object[0]), this, "ignoreInThenBranch");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryContinueVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("continue");
    }

    private class UnnecessaryContinueVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryContinueVisitor() {
        }

        @Override
        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryContinueInspection$UnnecessaryContinueVisitor", "visitContinueStatement"));
            }
            if (FileTypeUtils.isInServerPageFile(statement.getContainingFile())) {
                return;
            }
            PsiStatement continuedStatement = statement.findContinuedStatement();
            PsiStatement body = null;
            if (continuedStatement instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)continuedStatement;
                body = foreachStatement.getBody();
            } else if (continuedStatement instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)continuedStatement;
                body = forStatement.getBody();
            } else if (continuedStatement instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)continuedStatement;
                body = doWhileStatement.getBody();
            } else if (continuedStatement instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)continuedStatement;
                body = whileStatement.getBody();
            }
            if (body == null) {
                return;
            }
            if (UnnecessaryContinueInspection.this.ignoreInThenBranch && this.isInThenBranch(statement)) {
                return;
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                if (ControlFlowUtils.blockCompletesWithStatement(block, statement)) {
                    this.registerStatementError(statement, new Object[0]);
                }
            } else if (ControlFlowUtils.statementCompletesWithStatement(body, statement)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }

        private boolean isInThenBranch(PsiStatement statement) {
            PsiIfStatement ifStatement = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiIfStatement.class, true, PsiMethod.class, PsiLambdaExpression.class);
            if (ifStatement == null) {
                return false;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            return elseBranch != null && !PsiTreeUtil.isAncestor(elseBranch, statement, true);
        }
    }
}

