/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

class RemoveLeadingZeroFix
extends InspectionGadgetsFix {
    RemoveLeadingZeroFix() {
    }

    @Override
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("remove.leading.zero.to.make.decimal.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/RemoveLeadingZeroFix", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/RemoveLeadingZeroFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        int index;
        PsiElement element = descriptor.getPsiElement();
        String text = element.getText();
        int max = text.length() - 1;
        if (max < 1) {
            return;
        }
        for (index = 0; index < max && (text.charAt(index) == '0' || text.charAt(index) == '_'); ++index) {
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        String textWithoutLeadingZeros = text.substring(index);
        PsiExpression decimalNumber = factory.createExpressionFromText(textWithoutLeadingZeros, element);
        element.replace(decimalNumber);
    }
}

