/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegation(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/BoolUtils", "isNegation"));
        }
        if (!(expression instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)expression;
        IElementType tokenType = prefixExp.getOperationTokenType();
        return JavaTokenType.EXCL.equals(tokenType);
    }

    @Nullable
    private static PsiExpression getNegated(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/BoolUtils", "getNegated"));
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)expression;
        PsiExpression operand = prefixExp.getOperand();
        return ParenthesesUtils.stripParentheses(operand);
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression condition) {
        if (condition == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
            }
            return "";
        }
        if (condition instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
            PsiExpression contentExpression = parenthesizedExpression.getExpression();
            String string = '(' + BoolUtils.getNegatedExpressionText(contentExpression) + ')';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
            }
            return string;
        }
        if (BoolUtils.isNegation(condition)) {
            PsiExpression negated = BoolUtils.getNegated(condition);
            if (negated == null) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
                }
                return "";
            }
            String string = negated.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
            }
            return string;
        }
        if (ComparisonUtils.isComparison(condition)) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
            String negatedComparison = ComparisonUtils.getNegatedComparison(polyadicExpression.getOperationTokenType());
            StringBuilder result = new StringBuilder();
            PsiExpression[] operands = polyadicExpression.getOperands();
            boolean isEven = (operands.length & 1) != 1;
            int length = operands.length;
            for (int i = 0; i < length; ++i) {
                PsiExpression operand = operands[i];
                if (i > 0) {
                    if (isEven && (i & 1) != 1) {
                        PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand);
                        if (token != null) {
                            result.append(token.getText());
                        }
                    } else {
                        result.append(negatedComparison);
                    }
                }
                result.append(operand.getText());
            }
            String string = result.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
            }
            return string;
        }
        if (ParenthesesUtils.getPrecedence(condition) > 3) {
            String string = "!(" + condition.getText() + ')';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
            }
            return string;
        }
        String string = '!' + condition.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isTrue(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return false;
        }
        return "true".equals(expression.getText());
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isFalse(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return false;
        }
        return "false".equals(expression.getText());
    }
}

