/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.booleanIsAlwaysInverted;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanMethodIsAlwaysInvertedInspectionBase
extends GlobalJavaBatchInspectionTool {
    private static final Key<Boolean> ALWAYS_INVERTED = Key.create("ALWAYS_INVERTED_METHOD");

    private static boolean hasNonInvertedCalls(RefMethod refMethod) {
        Boolean alwaysInverted = refMethod.getUserData(ALWAYS_INVERTED);
        if (alwaysInverted == null) {
            return true;
        }
        if (refMethod.isExternalOverride()) {
            return true;
        }
        if (refMethod.isReferenced() && !alwaysInverted.booleanValue()) {
            return true;
        }
        Collection<RefMethod> superMethods = refMethod.getSuperMethods();
        for (RefMethod superMethod : superMethods) {
            if (!BooleanMethodIsAlwaysInvertedInspectionBase.hasNonInvertedCalls(superMethod)) continue;
            return true;
        }
        return false;
    }

    private static void traverseSuperMethods(RefMethod refMethod, GlobalJavaInspectionContext globalContext, GlobalJavaInspectionContext.UsagesProcessor processor) {
        Collection<RefMethod> superMethods = refMethod.getSuperMethods();
        for (RefMethod superMethod : superMethods) {
            BooleanMethodIsAlwaysInvertedInspectionBase.traverseSuperMethods(superMethod, globalContext, processor);
        }
        globalContext.enqueueMethodUsagesProcessor(refMethod, processor);
    }

    private static void checkMethodCall(RefElement refWhat, PsiElement element) {
        if (!(refWhat instanceof RefMethod)) {
            return;
        }
        final RefMethod refMethod = (RefMethod)refWhat;
        final PsiModifierListOwner psiElement = refMethod.getElement();
        if (!(psiElement instanceof PsiMethod)) {
            return;
        }
        final PsiMethod psiMethod = (PsiMethod)psiElement;
        if (!PsiType.BOOLEAN.equals(psiMethod.getReturnType())) {
            return;
        }
        element.accept(new JavaRecursiveElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                if (methodExpression.isReferenceTo(psiMethod)) {
                    if (BooleanMethodIsAlwaysInvertedInspectionBase.isInvertedMethodCall(methodExpression)) {
                        return;
                    }
                    refMethod.putUserData(ALWAYS_INVERTED, Boolean.FALSE);
                }
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                super.visitMethodReferenceExpression(expression);
                if (expression.isReferenceTo(psiElement)) {
                    refMethod.putUserData(ALWAYS_INVERTED, Boolean.FALSE);
                }
            }
        });
    }

    private static boolean isInvertedMethodCall(PsiReferenceExpression methodExpression) {
        IElementType tokenType;
        PsiPrefixExpression prefixExpression = PsiTreeUtil.getParentOfType((PsiElement)methodExpression, PsiPrefixExpression.class);
        if (methodExpression.getQualifierExpression() instanceof PsiSuperExpression) {
            return true;
        }
        return prefixExpression != null && (tokenType = prefixExpression.getOperationTokenType()).equals(JavaTokenType.EXCL);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("boolean.method.is.always.inverted.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DATA_FLOW_ISSUES;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if ("BooleanMethodIsAlwaysInverted" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "getShortName"));
        }
        return "BooleanMethodIsAlwaysInverted";
    }

    @Override
    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refManager", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "getAnnotator"));
        }
        return new BooleanInvertedAnnotator();
    }

    @Override
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "checkElement"));
        }
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (!refMethod.isReferenced()) {
                return null;
            }
            if (BooleanMethodIsAlwaysInvertedInspectionBase.hasNonInvertedCalls(refMethod)) {
                return null;
            }
            if (!refMethod.getSuperMethods().isEmpty()) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
            PsiIdentifier psiIdentifier = psiMethod.getNameIdentifier();
            if (psiIdentifier != null) {
                Collection<RefElement> inReferences = refMethod.getInReferences();
                if (inReferences.size() == 1) {
                    RefElement refElement = inReferences.iterator().next();
                    PsiElement usagesContainer = refElement.getElement();
                    if (usagesContainer == null) {
                        return null;
                    }
                    if (ReferencesSearch.search(psiMethod, new LocalSearchScope(usagesContainer)).forEach(new Processor<PsiReference>(){
                        private final Set<PsiReference> myFoundRefs = new HashSet<PsiReference>();

                        @Override
                        public boolean process(PsiReference reference) {
                            this.myFoundRefs.add(reference);
                            return this.myFoundRefs.size() < 2;
                        }
                    })) {
                        return null;
                    }
                }
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)psiIdentifier, InspectionsBundle.message("boolean.method.is.always.inverted.problem.descriptor", new Object[0]), (LocalQuickFix)this.getQuickFix(null), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            }
        }
        return null;
    }

    @Override
    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext context, final @NotNull ProblemDescriptionsProcessor descriptionsProcessor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "queryExternalUsagesRequests"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "queryExternalUsagesRequests"));
        }
        if (descriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionsProcessor", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase", "queryExternalUsagesRequests"));
        }
        manager.iterate(new RefJavaVisitor(){

            @Override
            public void visitMethod(final @NotNull RefMethod refMethod) {
                if (refMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase$3", "visitMethod"));
                }
                if (descriptionsProcessor.getDescriptions(refMethod) != null) {
                    GlobalJavaInspectionContext.UsagesProcessor usagesProcessor = new GlobalJavaInspectionContext.UsagesProcessor(){

                        @Override
                        public boolean process(PsiReference psiReference) {
                            PsiElement psiReferenceExpression = psiReference.getElement();
                            if (psiReferenceExpression instanceof PsiReferenceExpression && !BooleanMethodIsAlwaysInvertedInspectionBase.isInvertedMethodCall((PsiReferenceExpression)psiReferenceExpression)) {
                                descriptionsProcessor.ignoreElement(refMethod);
                            }
                            return false;
                        }
                    };
                    BooleanMethodIsAlwaysInvertedInspectionBase.traverseSuperMethods(refMethod, context, usagesProcessor);
                }
            }
        });
        return false;
    }

    private static class BooleanInvertedAnnotator
    extends RefGraphAnnotator {
        private BooleanInvertedAnnotator() {
        }

        @Override
        public void onInitialize(RefElement refElement) {
            if (refElement instanceof RefMethod) {
                PsiElement element = refElement.getElement();
                if (!(element instanceof PsiMethod)) {
                    return;
                }
                if (((PsiMethod)element).getReturnType() != PsiType.BOOLEAN) {
                    return;
                }
                refElement.putUserData(ALWAYS_INVERTED, Boolean.TRUE);
            }
        }

        @Override
        public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
            BooleanMethodIsAlwaysInvertedInspectionBase.checkMethodCall(refWhat, refFrom.getElement());
        }
    }
}

