/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.ProfileEx;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileImpl
extends ProfileEx
implements ModifiableModel,
InspectionProfile,
ExternalizableScheme {
    @NonNls
    public static final String INSPECTION_TOOL_TAG = "inspection_tool";
    @NonNls
    public static final String CLASS_TAG = "class";
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.ex.InspectionProfileImpl");
    @NonNls
    private static final String VALID_VERSION = "1.0";
    @NonNls
    private static final String VERSION_TAG = "version";
    @NonNls
    private static final String USED_LEVELS = "used_levels";
    public static boolean INIT_INSPECTIONS = false;
    private static Map<String, InspectionElementsMerger> ourMergers = null;
    private final InspectionToolRegistrar myRegistrar;
    @NotNull
    private final Map<String, Element> myUninstalledInspectionsSettings;
    private final ExternalInfo myExternalInfo;
    protected InspectionProfileImpl mySource;
    private Map<String, ToolsImpl> myTools;
    private Map<String, Boolean> myDisplayLevelMap;
    @Attribute(value="is_locked")
    private boolean myLockedProfile;
    private InspectionProfileImpl myBaseProfile;
    private String myEnabledTool;
    private String[] myScopesOrder;
    private String myDescription;
    private boolean myModified;
    private volatile boolean myInitialized;

    InspectionProfileImpl(@NotNull InspectionProfileImpl inspectionProfile) {
        if (inspectionProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        super(inspectionProfile.getName());
        this.myExternalInfo = new ExternalInfo();
        this.myTools = new THashMap();
        this.myBaseProfile = null;
        this.myEnabledTool = null;
        this.myRegistrar = inspectionProfile.myRegistrar;
        this.myUninstalledInspectionsSettings = new LinkedHashMap<String, Element>(inspectionProfile.myUninstalledInspectionsSettings);
        this.myBaseProfile = inspectionProfile.myBaseProfile;
        this.setProjectLevel(inspectionProfile.isProjectLevel());
        this.myLockedProfile = inspectionProfile.myLockedProfile;
        this.mySource = inspectionProfile;
        this.setProfileManager(inspectionProfile.getProfileManager());
        this.copyFrom(inspectionProfile);
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolRegistrar registrar, @NotNull ProfileManager profileManager) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        super(profileName);
        this.myExternalInfo = new ExternalInfo();
        this.myTools = new THashMap();
        this.myBaseProfile = null;
        this.myEnabledTool = null;
        this.myRegistrar = registrar;
        this.myBaseProfile = InspectionProfileImpl.getDefaultProfile();
        this.setProfileManager(profileManager);
        this.myUninstalledInspectionsSettings = new TreeMap<String, Element>();
    }

    public InspectionProfileImpl(@NotNull @NonNls String profileName) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        super(profileName);
        this.myExternalInfo = new ExternalInfo();
        this.myTools = new THashMap();
        this.myBaseProfile = null;
        this.myEnabledTool = null;
        this.myRegistrar = InspectionToolRegistrar.getInstance();
        this.setProfileManager(InspectionProfileManager.getInstance());
        this.myUninstalledInspectionsSettings = new TreeMap<String, Element>();
    }

    private static synchronized Map<String, InspectionElementsMerger> getMergers() {
        if (ourMergers == null) {
            ourMergers = new LinkedHashMap<String, InspectionElementsMerger>();
            for (InspectionElementsMerger merger : Extensions.getExtensions(InspectionElementsMerger.EP_NAME)) {
                ourMergers.put(merger.getMergedToolName(), merger);
            }
        }
        return ourMergers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static InspectionProfileImpl createSimple(@NotNull String name, @NotNull Project project, final InspectionToolWrapper ... toolWrappers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createSimple"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createSimple"));
        }
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createSimple"));
        }
        InspectionToolRegistrar registrar = new InspectionToolRegistrar(){

            @Override
            @NotNull
            public List<InspectionToolWrapper> createTools() {
                List<InspectionToolWrapper> list = Arrays.asList(toolWrappers);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl$1", "createTools"));
                }
                return list;
            }
        };
        InspectionProfileImpl profile = new InspectionProfileImpl(name, registrar, InspectionProfileManager.getInstance());
        boolean init = INIT_INSPECTIONS;
        try {
            INIT_INSPECTIONS = true;
            profile.initialize(project);
        }
        finally {
            INIT_INSPECTIONS = init;
        }
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            profile.enableTool(toolWrapper.getShortName(), project);
        }
        InspectionProfileImpl inspectionProfileImpl = profile;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createSimple"));
        }
        return inspectionProfileImpl;
    }

    private static boolean toolSettingsAreEqual(@NotNull String toolName, @NotNull InspectionProfileImpl profile1, @NotNull InspectionProfileImpl profile2) {
        if (toolName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toolSettingsAreEqual"));
        }
        if (profile1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile1", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toolSettingsAreEqual"));
        }
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile2", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toolSettingsAreEqual"));
        }
        Tools toolList1 = profile1.myTools.get(toolName);
        Tools toolList2 = profile2.myTools.get(toolName);
        return Comparing.equal(toolList1, toolList2);
    }

    @NotNull
    private static InspectionToolWrapper copyToolSettings(@NotNull InspectionToolWrapper toolWrapper) throws WriteExternalException, InvalidDataException {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "copyToolSettings"));
        }
        InspectionToolWrapper inspectionTool = toolWrapper.createCopy();
        if (toolWrapper.isInitialized()) {
            String tempRoot = "config";
            Element config = new Element(tempRoot);
            ((InspectionProfileEntry)toolWrapper.getTool()).writeSettings(config);
            ((InspectionProfileEntry)inspectionTool.getTool()).readSettings(config);
        }
        InspectionToolWrapper inspectionToolWrapper = inspectionTool;
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "copyToolSettings"));
        }
        return inspectionToolWrapper;
    }

    @NotNull
    public static InspectionProfileImpl getDefaultProfile() {
        InspectionProfileImpl inspectionProfileImpl = InspectionProfileImplHolder.DEFAULT_PROFILE;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getDefaultProfile"));
        }
        return inspectionProfileImpl;
    }

    @Override
    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    @Override
    public InspectionProfile getParentProfile() {
        return this.mySource;
    }

    @Override
    public String getBaseProfileName() {
        if (this.myBaseProfile == null) {
            return null;
        }
        return this.myBaseProfile.getName();
    }

    @Override
    public void setBaseProfile(InspectionProfile profile) {
        this.myBaseProfile = (InspectionProfileImpl)profile;
    }

    @Override
    public boolean isChanged() {
        if (this.mySource != null && this.mySource.myLockedProfile != this.myLockedProfile) {
            return true;
        }
        return this.myModified;
    }

    @Override
    public boolean isProperSetting(@NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "isProperSetting"));
        }
        if (this.myBaseProfile != null) {
            Tools currentTools;
            ToolsImpl tools = this.myBaseProfile.getTools(toolId, null);
            return !Comparing.equal(tools, currentTools = (Tools)this.myTools.get(toolId));
        }
        return false;
    }

    @Override
    public void resetToBase(Project project) {
        this.initInspectionTools(project);
        this.copyToolsConfigurations(this.myBaseProfile, project);
        this.myDisplayLevelMap = null;
    }

    @Override
    public void resetToEmpty(Project project) {
        InspectionToolWrapper[] profileEntries;
        this.initInspectionTools(project);
        for (InspectionToolWrapper toolWrapper : profileEntries = this.getInspectionTools(null)) {
            this.disableTool(toolWrapper.getShortName(), project);
        }
    }

    @Override
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element) {
        HighlightDisplayLevel level;
        if (inspectionToolKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionToolKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        Project project = element == null ? null : element.getProject();
        ToolsImpl tools = this.getTools(inspectionToolKey.toString(), project);
        HighlightDisplayLevel highlightDisplayLevel = level = tools != null ? tools.getLevel(element) : HighlightDisplayLevel.WARNING;
        if (!((SeverityProvider)((Object)this.getProfileManager())).getOwnSeverityRegistrar().isSeverityValid(level.getSeverity().getName())) {
            level = HighlightDisplayLevel.WARNING;
            this.setErrorLevel(inspectionToolKey, level, project);
        }
        return level;
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Element highlightElement;
        String version;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "readExternal"));
        }
        super.readExternal(element);
        if (!ApplicationManager.getApplication().isUnitTestMode() || this.myBaseProfile == null) {
            this.myBaseProfile = InspectionProfileImpl.getDefaultProfile();
        }
        if ((version = element.getAttributeValue(VERSION_TAG)) == null || !version.equals(VALID_VERSION)) {
            element = InspectionProfileConvertor.convertToNewFormat(element, this);
        }
        if ((highlightElement = element.getChild(USED_LEVELS)) != null) {
            ((SeverityProvider)((Object)this.getProfileManager())).getOwnSeverityRegistrar().readExternal(highlightElement);
        }
        StringInterner interner = new StringInterner();
        for (Element toolElement : element.getChildren(INSPECTION_TOOL_TAG)) {
            toolElement = toolElement.clone();
            JDOMUtil.internElement(toolElement, interner);
            this.myUninstalledInspectionsSettings.put(toolElement.getAttributeValue(CLASS_TAG), toolElement);
        }
    }

    @NotNull
    public Set<HighlightSeverity> getUsedSeverities() {
        LOG.assertTrue(this.myInitialized);
        HashSet<HighlightSeverity> result = new HashSet<HighlightSeverity>();
        for (ToolsImpl tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                result.add(state.getLevel().getSeverity());
            }
        }
        HashSet<HighlightSeverity> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUsedSeverities"));
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeInto(@NotNull Element element, boolean preserveCompatibility) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "serializeInto"));
        }
        element.setAttribute(VERSION_TAG, VALID_VERSION);
        super.serializeInto(element, preserveCompatibility);
        ExternalInfo externalInfo = this.myExternalInfo;
        synchronized (externalInfo) {
            if (!this.myInitialized) {
                for (Element el : this.myUninstalledInspectionsSettings.values()) {
                    element.addContent(el.clone());
                }
                return;
            }
        }
        Map<String, Boolean> diffMap = this.getDisplayLevelMap();
        if (diffMap != null) {
            diffMap = new TreeMap<String, Boolean>(diffMap);
            for (String toolName : this.myUninstalledInspectionsSettings.keySet()) {
                diffMap.put(toolName, false);
            }
            for (String toolName : diffMap.keySet()) {
                if (!this.myLockedProfile && diffMap.get(toolName).booleanValue()) {
                    this.markSettingsMerged(toolName, element);
                    continue;
                }
                Element toolElement = this.myUninstalledInspectionsSettings.get(toolName);
                if (toolElement == null) {
                    ToolsImpl toolList = this.myTools.get(toolName);
                    LOG.assertTrue(toolList != null);
                    Element inspectionElement = new Element(INSPECTION_TOOL_TAG);
                    inspectionElement.setAttribute(CLASS_TAG, toolName);
                    try {
                        toolList.writeExternal(inspectionElement);
                    }
                    catch (WriteExternalException e) {
                        LOG.error(e);
                        continue;
                    }
                    if (this.areSettingsMerged(toolName, inspectionElement)) continue;
                    element.addContent(inspectionElement);
                    continue;
                }
                element.addContent(toolElement.clone());
            }
        }
    }

    private void markSettingsMerged(String toolName, Element element) {
        InspectionElementsMerger merger;
        String mergedName = InspectionElementsMerger.getMergedMarkerName(toolName);
        if (!this.myUninstalledInspectionsSettings.containsKey(mergedName) && (merger = InspectionProfileImpl.getMergers().get(toolName)) != null && merger.markSettingsMerged(this.myUninstalledInspectionsSettings)) {
            element.addContent(new Element(INSPECTION_TOOL_TAG).setAttribute(CLASS_TAG, mergedName));
        }
    }

    private boolean areSettingsMerged(String toolName, Element inspectionElement) {
        InspectionElementsMerger merger = InspectionProfileImpl.getMergers().get(toolName);
        return merger != null && merger.areSettingsMerged(this.myUninstalledInspectionsSettings, inspectionElement);
    }

    public void collectDependentInspections(@NotNull InspectionToolWrapper toolWrapper, @NotNull Set<InspectionToolWrapper> dependentEntries, Project project) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "collectDependentInspections"));
        }
        if (dependentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentEntries", "com/intellij/codeInspection/ex/InspectionProfileImpl", "collectDependentInspections"));
        }
        String mainToolId = toolWrapper.getMainToolId();
        if (mainToolId != null) {
            InspectionToolWrapper dependentEntryWrapper = this.getInspectionTool(mainToolId, project);
            if (dependentEntryWrapper == null) {
                LOG.error("Can't find main tool: '" + mainToolId + "' which was specified in " + toolWrapper);
                return;
            }
            if (!dependentEntries.add(dependentEntryWrapper)) {
                this.collectDependentInspections(dependentEntryWrapper, dependentEntries, project);
            }
        }
    }

    @Override
    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, @NotNull PsiElement element) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getInspectionTool"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getInspectionTool"));
        }
        ToolsImpl toolList = this.getTools(shortName, element.getProject());
        return toolList == null ? null : toolList.getInspectionTool(element);
    }

    @Override
    @Nullable
    public InspectionProfileEntry getUnwrappedTool(@NotNull String shortName, @NotNull PsiElement element) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        InspectionToolWrapper tool = this.getInspectionTool(shortName, element);
        return tool == null ? null : (InspectionProfileEntry)tool.getTool();
    }

    @Override
    public <T extends InspectionProfileEntry> T getUnwrappedTool(@NotNull Key<T> shortNameKey, @NotNull PsiElement element) {
        if (shortNameKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNameKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        return (T)this.getUnwrappedTool(shortNameKey.toString(), element);
    }

    @Override
    public void modifyProfile(@NotNull Consumer<ModifiableModel> modelConsumer) {
        if (modelConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelConsumer", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyProfile"));
        }
        ModifiableModel model = this.getModifiableModel();
        modelConsumer.consume(model);
        try {
            model.commit();
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Override
    public <T extends InspectionProfileEntry> void modifyToolSettings(final @NotNull Key<T> shortNameKey, final @NotNull PsiElement psiElement, final @NotNull Consumer<T> toolConsumer) {
        if (shortNameKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNameKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyToolSettings"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyToolSettings"));
        }
        if (toolConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolConsumer", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyToolSettings"));
        }
        this.modifyProfile(new Consumer<ModifiableModel>(){

            @Override
            public void consume(@NotNull ModifiableModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/codeInspection/ex/InspectionProfileImpl$2", "consume"));
                }
                InspectionProfileEntry tool = model.getUnwrappedTool(shortNameKey.toString(), psiElement);
                toolConsumer.consume(tool);
            }
        });
    }

    @Override
    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, Project project) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getInspectionTool"));
        }
        ToolsImpl tools = this.getTools(shortName, project);
        return tools != null ? tools.getTool() : null;
    }

    public InspectionToolWrapper getToolById(@NotNull String id, @NotNull PsiElement element) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolById"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolById"));
        }
        this.initInspectionTools(element.getProject());
        for (ToolsImpl toolList : this.myTools.values()) {
            InspectionToolWrapper tool = toolList.getInspectionTool(element);
            String toolId = tool instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)tool).getID() : tool.getShortName();
            if (!id.equals(toolId)) continue;
            return tool;
        }
        return null;
    }

    @Override
    public void save() throws IOException {
        InspectionProfileManager.getInstance().fireProfileChanged(this);
    }

    @Override
    public boolean isEditable() {
        return this.myEnabledTool == null;
    }

    @Override
    public void setEditable(String displayName) {
        this.myEnabledTool = displayName;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.isEditable() ? this.getName() : this.myEnabledTool;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getDisplayName"));
        }
        return string;
    }

    @Override
    public void scopesChanged() {
        for (ScopeToolState toolState : this.getAllTools(null)) {
            toolState.scopesChanged();
        }
        InspectionProfileManager.getInstance().fireProfileChanged(this);
    }

    @Override
    @Transient
    public boolean isProfileLocked() {
        return this.myLockedProfile;
    }

    @Override
    public void lockProfile(boolean isLocked) {
        this.myLockedProfile = isLocked;
    }

    @Override
    @NotNull
    public InspectionToolWrapper[] getInspectionTools(@Nullable PsiElement element) {
        this.initInspectionTools(element == null ? null : element.getProject());
        ArrayList<InspectionToolWrapper> result = new ArrayList<InspectionToolWrapper>();
        for (ToolsImpl toolList : this.myTools.values()) {
            result.add(toolList.getInspectionTool(element));
        }
        InspectionToolWrapper[] inspectionToolWrapperArray = result.toArray(new InspectionToolWrapper[result.size()]);
        if (inspectionToolWrapperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getInspectionTools"));
        }
        return inspectionToolWrapperArray;
    }

    @Override
    @NotNull
    public List<Tools> getAllEnabledInspectionTools(Project project) {
        this.initInspectionTools(project);
        ArrayList<Tools> result = new ArrayList<Tools>();
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            result.add(toolList);
        }
        ArrayList<Tools> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getAllEnabledInspectionTools"));
        }
        return arrayList;
    }

    @Override
    public void disableTool(@NotNull String toolId, @NotNull PsiElement element) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        this.getTools(toolId, element.getProject()).disableTool(element);
    }

    public void disableToolByDefault(@NotNull List<String> toolIds, Project project) {
        if (toolIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolIds", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableToolByDefault"));
        }
        for (String toolId : toolIds) {
            this.getToolDefaultState(toolId, project).setEnabled(false);
        }
    }

    @NotNull
    public ScopeToolState getToolDefaultState(@NotNull String toolId, Project project) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolDefaultState"));
        }
        ScopeToolState scopeToolState = this.getTools(toolId, project).getDefaultState();
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolDefaultState"));
        }
        return scopeToolState;
    }

    public void enableToolsByDefault(@NotNull List<String> toolIds, Project project) {
        if (toolIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolIds", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableToolsByDefault"));
        }
        for (String toolId : toolIds) {
            this.getToolDefaultState(toolId, project).setEnabled(true);
        }
    }

    public boolean wasInitialized() {
        return this.myInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInspectionTools(@Nullable Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !INIT_INSPECTIONS) {
            return;
        }
        if (this.myInitialized) {
            return;
        }
        ExternalInfo externalInfo = this.myExternalInfo;
        synchronized (externalInfo) {
            if (this.myInitialized) {
                return;
            }
            this.myInitialized = this.initialize(project);
        }
    }

    private boolean initialize(@Nullable Project project) {
        List<InspectionToolWrapper> tools;
        if (this.myBaseProfile != null) {
            this.myBaseProfile.initInspectionTools(project);
        }
        try {
            tools = this.createTools(project);
        }
        catch (ProcessCanceledException ignored) {
            return false;
        }
        final HashMap<String, List<String>> dependencies = new HashMap<String, List<String>>();
        for (InspectionToolWrapper toolWrapper : tools) {
            String shortName = toolWrapper.getShortName();
            HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
            if (key == null) {
                final Object extension = toolWrapper.getExtension();
                Computable<String> computable = extension == null ? new Computable.PredefinedValueComputable<String>(toolWrapper.getDisplayName()) : new Computable<String>(){

                    @Override
                    public String compute() {
                        return extension.getDisplayName();
                    }
                };
                key = toolWrapper instanceof LocalInspectionToolWrapper ? HighlightDisplayKey.register(shortName, computable, ((LocalInspectionToolWrapper)toolWrapper).getID(), ((LocalInspectionToolWrapper)toolWrapper).getAlternativeID()) : HighlightDisplayKey.register(shortName, computable);
            }
            LOG.assertTrue(key != null, shortName + " ; number of initialized tools: " + this.myTools.size());
            HighlightDisplayLevel level = this.myBaseProfile != null ? this.myBaseProfile.getErrorLevel(key, project) : toolWrapper.getDefaultLevel();
            boolean enabled = this.myBaseProfile != null ? this.myBaseProfile.isToolEnabled(key) : toolWrapper.isEnabledByDefault();
            ToolsImpl toolsList = new ToolsImpl(toolWrapper, level, !this.myLockedProfile && enabled, enabled);
            Element element = this.myUninstalledInspectionsSettings.remove(shortName);
            try {
                Element merged;
                InspectionElementsMerger merger;
                if (element != null) {
                    toolsList.readExternal(element, this, dependencies);
                } else if (!this.myUninstalledInspectionsSettings.containsKey(InspectionElementsMerger.getMergedMarkerName(shortName)) && (merger = InspectionProfileImpl.getMergers().get(shortName)) != null && (merged = merger.merge(this.myUninstalledInspectionsSettings)) != null) {
                    toolsList.readExternal(merged, this, dependencies);
                }
            }
            catch (InvalidDataException e) {
                LOG.error("Can't read settings for " + toolWrapper, e);
            }
            this.myTools.put(toolWrapper.getShortName(), toolsList);
        }
        GraphGenerator<String> graphGenerator = GraphGenerator.create(CachingSemiGraph.create(new GraphGenerator.SemiGraph<String>(){

            @Override
            public Collection<String> getNodes() {
                return dependencies.keySet();
            }

            @Override
            public Iterator<String> getIn(String n) {
                return ((List)dependencies.get(n)).iterator();
            }
        }));
        DFSTBuilder<String> builder = new DFSTBuilder<String>(graphGenerator);
        if (builder.isAcyclic()) {
            List<String> scopes = builder.getSortedNodes();
            this.myScopesOrder = ArrayUtil.toStringArray(scopes);
        }
        if (this.mySource != null) {
            this.copyToolsConfigurations(this.mySource, project);
        }
        return true;
    }

    @Transient
    @Nullable
    public String[] getScopesOrder() {
        return this.myScopesOrder;
    }

    public void setScopesOrder(String[] scopesOrder) {
        this.myScopesOrder = scopesOrder;
    }

    @NotNull
    private List<InspectionToolWrapper> createTools(Project project) {
        if (this.mySource != null) {
            List<InspectionToolWrapper> list = ContainerUtil.map(this.mySource.getDefaultStates(project), new Function<ScopeToolState, InspectionToolWrapper>(){

                @Override
                @NotNull
                public InspectionToolWrapper fun(@NotNull ScopeToolState state) {
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInspection/ex/InspectionProfileImpl$5", "fun"));
                    }
                    InspectionToolWrapper inspectionToolWrapper = state.getTool();
                    if (inspectionToolWrapper == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl$5", "fun"));
                    }
                    return inspectionToolWrapper;
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createTools"));
            }
            return list;
        }
        List<InspectionToolWrapper> list = this.myRegistrar.createTools();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createTools"));
        }
        return list;
    }

    private HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, Project project) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        ToolsImpl tools = this.getTools(key.toString(), project);
        LOG.assertTrue(tools != null, "profile name: " + this.myName + " base profile: " + (this.myBaseProfile != null ? this.myBaseProfile.getName() : "-") + " key: " + key);
        return tools.getLevel();
    }

    @Override
    @NotNull
    public ModifiableModel getModifiableModel() {
        InspectionProfileImpl modifiableModel = new InspectionProfileImpl(this);
        modifiableModel.myExternalInfo.copy(this.myExternalInfo);
        InspectionProfileImpl inspectionProfileImpl = modifiableModel;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getModifiableModel"));
        }
        return inspectionProfileImpl;
    }

    @Override
    public void copyFrom(@NotNull InspectionProfile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ex/InspectionProfileImpl", "copyFrom"));
        }
        super.copyFrom(profile);
        this.myBaseProfile = ((InspectionProfileImpl)profile).myBaseProfile;
    }

    private void copyToolsConfigurations(@NotNull InspectionProfileImpl profile, @Nullable Project project) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ex/InspectionProfileImpl", "copyToolsConfigurations"));
        }
        try {
            for (ToolsImpl toolList : profile.myTools.values()) {
                ToolsImpl tools = this.myTools.get(toolList.getShortName());
                ScopeToolState defaultState = toolList.getDefaultState();
                tools.setDefaultState(InspectionProfileImpl.copyToolSettings(defaultState.getTool()), defaultState.isEnabled(), defaultState.getLevel());
                tools.removeAllScopes();
                List<ScopeToolState> nonDefaultToolStates = toolList.getNonDefaultTools();
                if (nonDefaultToolStates != null) {
                    for (ScopeToolState state : nonDefaultToolStates) {
                        InspectionToolWrapper toolWrapper = InspectionProfileImpl.copyToolSettings(state.getTool());
                        NamedScope scope = state.getScope(project);
                        if (scope != null) {
                            tools.addTool(scope, toolWrapper, state.isEnabled(), state.getLevel());
                            continue;
                        }
                        tools.addTool(state.getScopeName(), toolWrapper, state.isEnabled(), state.getLevel());
                    }
                }
                tools.setEnabled(toolList.isEnabled());
            }
        }
        catch (WriteExternalException e) {
            LOG.error(e);
        }
        catch (InvalidDataException e) {
            LOG.error(e);
        }
    }

    @Override
    public void cleanup(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "cleanup"));
        }
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            for (InspectionToolWrapper toolWrapper : toolList.getAllTools()) {
                toolWrapper.projectClosed(project);
                toolWrapper.cleanup(project);
            }
        }
    }

    public void enableTool(@NotNull String toolId, Project project) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTool"));
        }
        ToolsImpl tools = this.getTools(toolId, project);
        tools.setEnabled(true);
        if (tools.getNonDefaultTools() == null) {
            tools.getDefaultState().setEnabled(true);
        }
    }

    @Override
    public void enableTool(@NotNull String inspectionTool, NamedScope namedScope, Project project) {
        if (inspectionTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTool", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTool"));
        }
        this.getTools(inspectionTool, project).enableTool(namedScope, project);
    }

    public void enableTools(@NotNull List<String> inspectionTools, NamedScope namedScope, Project project) {
        if (inspectionTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTools", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTools"));
        }
        for (String inspectionTool : inspectionTools) {
            this.enableTool(inspectionTool, namedScope, project);
        }
    }

    @Override
    public void disableTool(@NotNull String inspectionTool, NamedScope namedScope, @NotNull Project project) {
        if (inspectionTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTool", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        this.getTools(inspectionTool, project).disableTool(namedScope, project);
    }

    public void disableTools(@NotNull List<String> inspectionTools, NamedScope namedScope, @NotNull Project project) {
        if (inspectionTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTools", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTools"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTools"));
        }
        for (String inspectionTool : inspectionTools) {
            this.disableTool(inspectionTool, namedScope, project);
        }
    }

    @Override
    public void disableTool(@NotNull String inspectionTool, Project project) {
        if (inspectionTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTool", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        ToolsImpl tools = this.getTools(inspectionTool, project);
        tools.setEnabled(false);
        if (tools.getNonDefaultTools() == null) {
            tools.getDefaultState().setEnabled(false);
        }
    }

    @Override
    public void setErrorLevel(@NotNull HighlightDisplayKey key, @NotNull HighlightDisplayLevel level, Project project) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        this.getTools(key.toString(), project).setLevel(level);
    }

    @Override
    public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
        if (key == null) {
            return false;
        }
        ToolsImpl toolState = this.getTools(key.toString(), element == null ? null : element.getProject());
        return toolState != null && toolState.isEnabled(element);
    }

    @Override
    public boolean isToolEnabled(HighlightDisplayKey key) {
        return this.isToolEnabled(key, null);
    }

    @Override
    public boolean isExecutable(Project project) {
        this.initInspectionTools(project);
        for (ToolsImpl tools : this.myTools.values()) {
            if (!tools.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void commit() throws IOException {
        LOG.assertTrue(this.mySource != null);
        this.mySource.commit(this);
        this.getProfileManager().updateProfile(this.mySource);
        this.mySource = null;
    }

    private void commit(@NotNull InspectionProfileImpl inspectionProfile) {
        if (inspectionProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/codeInspection/ex/InspectionProfileImpl", "commit"));
        }
        this.setName(inspectionProfile.getName());
        this.setDescription(inspectionProfile.getDescription());
        this.setProjectLevel(inspectionProfile.isProjectLevel());
        this.myLockedProfile = inspectionProfile.myLockedProfile;
        this.myDisplayLevelMap = inspectionProfile.myDisplayLevelMap;
        this.myBaseProfile = inspectionProfile.myBaseProfile;
        this.myTools = inspectionProfile.myTools;
        this.myProfileManager = inspectionProfile.getProfileManager();
        this.myExternalInfo.copy(inspectionProfile.getExternalInfo());
        InspectionProfileManager.getInstance().fireProfileChanged(inspectionProfile);
    }

    @Tag
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    @Override
    public void convert(@NotNull Element element, @NotNull Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "convert"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "convert"));
        }
        this.initInspectionTools(project);
        Element scopes = element.getChild("scopes");
        if (scopes == null) {
            return;
        }
        List children = scopes.getChildren("scope");
        for (Object s : children) {
            NamedScope scope;
            InspectionProfileImpl inspectionProfile;
            Element scopeElement = (Element)s;
            String profile = scopeElement.getAttributeValue("profile");
            if (profile == null || (inspectionProfile = (InspectionProfileImpl)this.getProfileManager().getProfile(profile)) == null || (scope = this.getProfileManager().getScopesManager().getScope(scopeElement.getAttributeValue("name"))) == null) continue;
            for (InspectionToolWrapper toolWrapper : inspectionProfile.getInspectionTools(null)) {
                HighlightDisplayKey key = HighlightDisplayKey.find(toolWrapper.getShortName());
                try {
                    InspectionToolWrapper toolWrapperCopy = InspectionProfileImpl.copyToolSettings(toolWrapper);
                    HighlightDisplayLevel errorLevel = inspectionProfile.getErrorLevel(key, null, project);
                    this.getTools(toolWrapper.getShortName(), project).addTool(scope, toolWrapperCopy, inspectionProfile.isToolEnabled(key), errorLevel);
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
        this.reduceConvertedScopes();
    }

    private void reduceConvertedScopes() {
        for (ToolsImpl tools : this.myTools.values()) {
            ScopeToolState toolState = tools.getDefaultState();
            List<ScopeToolState> nonDefaultTools = tools.getNonDefaultTools();
            if (nonDefaultTools == null) continue;
            boolean equal = true;
            boolean isEnabled = toolState.isEnabled();
            for (ScopeToolState state : nonDefaultTools) {
                isEnabled |= state.isEnabled();
                if (state.equalTo(toolState)) continue;
                equal = false;
            }
            tools.setEnabled(isEnabled);
            if (!equal) continue;
            tools.removeAllScopes();
        }
    }

    @Override
    @NotNull
    public ExternalInfo getExternalInfo() {
        ExternalInfo externalInfo = this.myExternalInfo;
        if (externalInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getExternalInfo"));
        }
        return externalInfo;
    }

    @NotNull
    public List<ScopeToolState> getAllTools(Project project) {
        this.initInspectionTools(project);
        ArrayList<ScopeToolState> result = new ArrayList<ScopeToolState>();
        for (ToolsImpl tools : this.myTools.values()) {
            result.addAll(tools.getTools());
        }
        ArrayList<ScopeToolState> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getAllTools"));
        }
        return arrayList;
    }

    @NotNull
    public List<ScopeToolState> getDefaultStates(Project project) {
        this.initInspectionTools(project);
        ArrayList<ScopeToolState> result = new ArrayList<ScopeToolState>();
        for (ToolsImpl tools : this.myTools.values()) {
            result.add(tools.getDefaultState());
        }
        ArrayList<ScopeToolState> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getDefaultStates"));
        }
        return arrayList;
    }

    @NotNull
    public List<ScopeToolState> getNonDefaultTools(@NotNull String shortName, Project project) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getNonDefaultTools"));
        }
        ArrayList<ScopeToolState> result = new ArrayList<ScopeToolState>();
        List<ScopeToolState> nonDefaultTools = this.getTools(shortName, project).getNonDefaultTools();
        if (nonDefaultTools != null) {
            result.addAll(nonDefaultTools);
        }
        ArrayList<ScopeToolState> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getNonDefaultTools"));
        }
        return arrayList;
    }

    public boolean isToolEnabled(@NotNull HighlightDisplayKey key, NamedScope namedScope, Project project) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "isToolEnabled"));
        }
        return this.getTools(key.toString(), project).isEnabled(namedScope, project);
    }

    @Deprecated
    public void removeScope(@NotNull String toolId, int scopeIdx, Project project) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScope"));
        }
        this.getTools(toolId, project).removeScope(scopeIdx);
    }

    public void removeScope(@NotNull String toolId, @NotNull String scopeName, Project project) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScope"));
        }
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScope"));
        }
        this.getTools(toolId, project).removeScope(scopeName);
    }

    public void removeScopes(@NotNull List<String> toolIds, @NotNull String scopeName, Project project) {
        if (toolIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolIds", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScopes"));
        }
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScopes"));
        }
        for (String toolId : toolIds) {
            this.removeScope(toolId, scopeName, project);
        }
    }

    @Nullable
    private Map<String, Boolean> getDisplayLevelMap() {
        if (this.myBaseProfile == null) {
            return null;
        }
        if (this.myDisplayLevelMap == null) {
            this.initInspectionTools(null);
            this.myDisplayLevelMap = new TreeMap<String, Boolean>();
            for (String toolId : this.myTools.keySet()) {
                this.myDisplayLevelMap.put(toolId, InspectionProfileImpl.toolSettingsAreEqual(toolId, this.myBaseProfile, this));
            }
        }
        return this.myDisplayLevelMap;
    }

    @Override
    public void profileChanged() {
        this.myDisplayLevelMap = null;
    }

    @Transient
    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, NamedScope scope, Project project) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        ToolsImpl tools = this.getTools(key.toString(), project);
        HighlightDisplayLevel highlightDisplayLevel = tools != null ? tools.getLevel(scope, project) : HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        return highlightDisplayLevel;
    }

    public ScopeToolState addScope(@NotNull InspectionToolWrapper toolWrapper, NamedScope scope, @NotNull HighlightDisplayLevel level, boolean enabled, Project project) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "addScope"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "addScope"));
        }
        return this.getTools(toolWrapper.getShortName(), project).prependTool(scope, toolWrapper, enabled, level);
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key, @NotNull HighlightDisplayLevel level, String scopeName, Project project) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        this.getTools(key.toString(), project).setLevel(level, scopeName, project);
    }

    public void setErrorLevel(@NotNull List<HighlightDisplayKey> keys, @NotNull HighlightDisplayLevel level, String scopeName, Project project) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        for (HighlightDisplayKey key : keys) {
            this.setErrorLevel(key, level, scopeName, project);
        }
    }

    public ToolsImpl getTools(@NotNull String toolId, Project project) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getTools"));
        }
        this.initInspectionTools(project);
        return this.myTools.get(toolId);
    }

    public void enableAllTools(Project project) {
        for (InspectionToolWrapper entry : this.getInspectionTools(null)) {
            this.enableTool(entry.getShortName(), project);
        }
    }

    public void disableAllTools(Project project) {
        for (InspectionToolWrapper entry : this.getInspectionTools(null)) {
            this.disableTool(entry.getShortName(), project);
        }
    }

    @NotNull
    public String toString() {
        String string = this.mySource == null ? this.getName() : this.getName() + " (copy)";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toString"));
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && ((InspectionProfileImpl)o).getProfileManager() == this.getProfileManager();
    }

    private static class InspectionProfileImplHolder {
        private static final InspectionProfileImpl DEFAULT_PROFILE = new InspectionProfileImpl("Default");

        private InspectionProfileImplHolder() {
        }
    }
}

