/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.annotations.NotNull;

class ComponentManagerConfigurator {
    private final ComponentManagerImpl myComponentManager;

    public ComponentManagerConfigurator(ComponentManagerImpl componentManager) {
        this.myComponentManager = componentManager;
    }

    private void loadConfiguration(@NotNull ComponentConfig[] configs, boolean defaultProject, PluginDescriptor descriptor) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/openapi/components/impl/ComponentManagerConfigurator", "loadConfiguration"));
        }
        for (ComponentConfig config : configs) {
            this.loadSingleConfig(defaultProject, config, descriptor);
        }
    }

    private void loadSingleConfig(boolean defaultProject, @NotNull ComponentConfig config, PluginDescriptor descriptor) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/openapi/components/impl/ComponentManagerConfigurator", "loadSingleConfig"));
        }
        if (defaultProject && !config.isLoadForDefaultProject()) {
            return;
        }
        if (!this.myComponentManager.isComponentSuitable(config.options)) {
            return;
        }
        this.myComponentManager.registerComponent(config, descriptor);
    }

    public void loadComponentsConfiguration(ComponentConfig[] components, PluginDescriptor descriptor, boolean defaultProject) {
        if (components == null) {
            return;
        }
        this.loadConfiguration(components, defaultProject, descriptor);
    }
}

