/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CollectingAsyncResult<T> {
    private final List<AsyncResult<T>> asyncResults = new SmartList<AsyncResult<T>>();

    public void add(@NotNull AsyncResult<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/util/CollectingAsyncResult", "add"));
        }
        this.asyncResults.add(callback);
    }

    @NotNull
    public AsyncResult<List<T>> create() {
        int size = this.asyncResults.size();
        if (size == 0) {
            AsyncResult<List<T>> asyncResult = AsyncResult.doneList();
            if (asyncResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/CollectingAsyncResult", "create"));
            }
            return asyncResult;
        }
        final AbstractList results = size == 1 ? new SmartList() : new ArrayList(size);
        final AsyncResult<List<T>> totalResult = new AsyncResult<List<T>>(this.asyncResults.size(), results);
        Consumer resultConsumer = new Consumer<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(T result) {
                List list = results;
                synchronized (list) {
                    results.add(result);
                }
                totalResult.setDone();
            }
        };
        for (AsyncResult<T> subResult : this.asyncResults) {
            subResult.doWhenDone(resultConsumer).notifyWhenRejected(totalResult);
        }
        AsyncResult<List<T>> asyncResult = totalResult;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/CollectingAsyncResult", "create"));
        }
        return asyncResult;
    }

    public boolean isEmpty() {
        return this.asyncResults.isEmpty();
    }
}

