/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlyStrongTypeCastInspection
extends BaseInspection {
    public boolean ignoreInMatchingInstanceof = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.strong.type.cast.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType expectedType = (PsiType)infos[0];
        String typeText = expectedType.getPresentableText();
        String string = InspectionGadgetsBundle.message("overly.strong.type.cast.problem.descriptor", typeText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("overly.strong.type.cast.ignore.in.matching.instanceof.option", new Object[0]), this, "ignoreInMatchingInstanceof");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new OverlyStrongCastFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyStrongTypeCastVisitor();
    }

    private class OverlyStrongTypeCastVisitor
    extends BaseInspectionVisitor {
        private OverlyStrongTypeCastVisitor() {
        }

        @Override
        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            PsiArrayType arrayType;
            PsiType componentType;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection$OverlyStrongTypeCastVisitor", "visitTypeCastExpression"));
            }
            super.visitTypeCastExpression(expression);
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType operandType = operand.getType();
            if (operandType == null) {
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, true);
            if (expectedType == null) {
                return;
            }
            if (expectedType.equals(type)) {
                return;
            }
            PsiClass resolved = PsiUtil.resolveClassInType(expectedType);
            if (resolved != null && !resolved.isPhysical()) {
                return;
            }
            if (expectedType.isAssignableFrom(operandType)) {
                return;
            }
            if (this.isTypeParameter(expectedType)) {
                return;
            }
            if (expectedType instanceof PsiArrayType && this.isTypeParameter(componentType = (arrayType = (PsiArrayType)expectedType).getDeepComponentType())) {
                return;
            }
            if (type instanceof PsiPrimitiveType || expectedType instanceof PsiPrimitiveType) {
                return;
            }
            if (PsiPrimitiveType.getUnboxedType(type) != null || PsiPrimitiveType.getUnboxedType(expectedType) != null) {
                return;
            }
            if (expectedType instanceof PsiClassType) {
                PsiClassType classType;
                PsiClassType rawType;
                PsiClassType expectedClassType = (PsiClassType)expectedType;
                PsiClassType expectedRawType = expectedClassType.rawType();
                if (type.equals(expectedRawType)) {
                    return;
                }
                if (type instanceof PsiClassType && (rawType = (classType = (PsiClassType)type).rawType()).equals(expectedRawType)) {
                    return;
                }
                if (type instanceof PsiArrayType) {
                    return;
                }
            }
            if (OverlyStrongTypeCastInspection.this.ignoreInMatchingInstanceof && InstanceOfUtils.hasAgreeingInstanceof(expression)) {
                return;
            }
            PsiTypeElement castTypeElement = expression.getCastType();
            if (castTypeElement == null) {
                return;
            }
            if (operand instanceof PsiFunctionalExpression && !LambdaUtil.isFunctionalType(expectedType)) {
                return;
            }
            this.registerError((PsiElement)castTypeElement, expectedType);
        }

        private boolean isTypeParameter(PsiType type) {
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            return aClass != null && aClass instanceof PsiTypeParameter;
        }
    }

    private static class OverlyStrongCastFix
    extends InspectionGadgetsFix {
        private OverlyStrongCastFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection$OverlyStrongCastFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("overly.strong.type.cast.weaken.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection$OverlyStrongCastFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement castTypeElement = descriptor.getPsiElement();
            PsiTypeCastExpression expression = (PsiTypeCastExpression)castTypeElement.getParent();
            if (expression == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, true);
            if (expectedType == null) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            String newExpression = '(' + expectedType.getCanonicalText() + ')' + operand.getText();
            PsiReplacementUtil.replaceExpressionAndShorten(expression, newExpression);
        }
    }
}

