/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

class InnerClassReferenceVisitor
extends JavaRecursiveElementVisitor {
    private final PsiClass innerClass;
    private boolean referencesStaticallyAccessible;

    public InnerClassReferenceVisitor(@NotNull PsiClass innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "com/siyeh/ig/memory/InnerClassReferenceVisitor", "<init>"));
        }
        this.referencesStaticallyAccessible = true;
        this.innerClass = innerClass;
    }

    public boolean canInnerClassBeStatic() {
        PsiClass superClass = this.innerClass.getSuperClass();
        if (superClass != null && !this.isClassStaticallyAccessible(superClass)) {
            return false;
        }
        return this.referencesStaticallyAccessible;
    }

    private boolean isClassStaticallyAccessible(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/memory/InnerClassReferenceVisitor", "isClassStaticallyAccessible"));
        }
        if (PsiTreeUtil.isAncestor(this.innerClass, aClass, false) || aClass.hasModifierProperty("static")) {
            return true;
        }
        PsiClass containingClass = aClass.getContainingClass();
        return containingClass == null || InheritanceUtil.isInheritorOrSelf(this.innerClass, containingClass, true);
    }

    @Override
    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/memory/InnerClassReferenceVisitor", "visitThisExpression"));
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitThisExpression(expression);
        if (this.hasContainingClassQualifier(expression)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    @Override
    public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/memory/InnerClassReferenceVisitor", "visitSuperExpression"));
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitSuperExpression(expression);
        if (this.hasContainingClassQualifier(expression)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    private boolean hasContainingClassQualifier(PsiQualifiedExpression expression) {
        PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
        if (qualifier == null) {
            return false;
        }
        return !this.innerClass.equals(qualifier.resolve());
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitReferenceExpression(expression);
        PsiExpression qualifierExpression = ParenthesesUtils.stripParentheses(expression.getQualifierExpression());
        if (qualifierExpression != null) {
            return;
        }
        PsiElement target = expression.resolve();
        if (target instanceof PsiLocalVariable || target instanceof PsiParameter) {
            return;
        }
        if (target instanceof PsiMethod || target instanceof PsiField) {
            PsiMember member = (PsiMember)target;
            if (member.hasModifierProperty("static") || PsiTreeUtil.isAncestor(this.innerClass, member, true)) {
                return;
            }
            if (!member.hasModifierProperty("private")) {
                PsiClass containingClass = member.getContainingClass();
                if (InheritanceUtil.isInheritorOrSelf(this.innerClass, containingClass, true)) {
                    return;
                }
                PsiClass parentClass = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
                while (parentClass != null && PsiTreeUtil.isAncestor(this.innerClass, parentClass, true)) {
                    if (InheritanceUtil.isInheritorOrSelf(parentClass, containingClass, true)) {
                        return;
                    }
                    parentClass = PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, true);
                }
            }
            this.referencesStaticallyAccessible = false;
        }
    }

    @Override
    public void visitNewExpression(PsiNewExpression expression) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitNewExpression(expression);
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        if (classReference == null) {
            return;
        }
        PsiElement target = classReference.resolve();
        if (!(target instanceof PsiClass)) {
            return;
        }
        if (!this.isClassStaticallyAccessible((PsiClass)target)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    @Override
    public void visitTypeElement(PsiTypeElement typeElement) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitTypeElement(typeElement);
        PsiType type = typeElement.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass instanceof PsiTypeParameter && !PsiTreeUtil.isAncestor(this.innerClass, aClass, true)) {
            this.referencesStaticallyAccessible = false;
        }
    }
}

