/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmbiguousFieldAccessInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("ambiguous.field.access.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass fieldClass = (PsiClass)infos[0];
        PsiVariable variable = (PsiVariable)infos[1];
        if (variable instanceof PsiLocalVariable) {
            String string = InspectionGadgetsBundle.message("ambiguous.field.access.hides.local.variable.problem.descriptor", fieldClass.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection", "buildErrorString"));
            }
            return string;
        }
        if (variable instanceof PsiParameter) {
            String string = InspectionGadgetsBundle.message("ambiguous.field.access.hides.parameter.problem.descriptor", fieldClass.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("ambiguous.field.access.hides.field.problem.descriptor", fieldClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AmbiguousMethodCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AmbiguousFieldAccessVisitor();
    }

    private static class AmbiguousFieldAccessVisitor
    extends BaseInspectionVisitor {
        private AmbiguousFieldAccessVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            String referenceText;
            super.visitReferenceExpression(expression);
            if (expression.isQualified()) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass(expression);
            if (containingClass == null) {
                return;
            }
            PsiElement target = expression.resolve();
            if (target == null) {
                return;
            }
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null || !containingClass.isInheritor(fieldClass, true)) {
                return;
            }
            PsiElement parent = containingClass.getParent();
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(expression.getProject()).getResolveHelper();
            PsiVariable variable = resolveHelper.resolveAccessibleReferencedVariable(referenceText = expression.getText(), parent);
            if (variable == null || field == variable) {
                return;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)variable, (PsiElement)containingClass);
            if (commonParent == null) {
                return;
            }
            this.registerError((PsiElement)expression, fieldClass, variable);
        }
    }

    private static class AmbiguousMethodCallFix
    extends InspectionGadgetsFix {
        private AmbiguousMethodCallFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("ambiguous.field.access.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection$AmbiguousMethodCallFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection$AmbiguousMethodCallFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            String newExpressionText = "super." + referenceExpression.getText();
            PsiReplacementUtil.replaceExpression(referenceExpression, newExpressionText);
        }
    }
}

