/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.TransferToEDTQueue;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightingSessionImpl
implements HighlightingSession {
    @NotNull
    private final PsiFile myPsiFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    private final EditorColorsScheme myEditorColorsScheme;
    private final int myPassId;
    @NotNull
    private final TextRange myRestrictRange;
    @NotNull
    private final Project myProject;
    private final Document myDocument;
    private final Map<TextRange, RangeMarker> myRanges2markersCache;
    private volatile boolean myDisposed;
    private final TransferToEDTQueue<HighlightInfo> myAddHighlighterInEDTQueue;
    private final TransferToEDTQueue<RangeHighlighterEx> myDisposeHighlighterInEDTQueue;

    public HighlightingSessionImpl(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull ProgressIndicator progressIndicator, EditorColorsScheme editorColorsScheme, int passId, @NotNull TextRange restrictRange) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "<init>"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "<init>"));
        }
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictRange", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "<init>"));
        }
        this.myRanges2markersCache = new THashMap();
        this.myAddHighlighterInEDTQueue = new TransferToEDTQueue<HighlightInfo>("Apply highlighting results", new Processor<HighlightInfo>(){

            @Override
            public boolean process(HighlightInfo info) {
                EditorColorsScheme colorsScheme = HighlightingSessionImpl.this.getColorsScheme();
                UpdateHighlightersUtil.addHighlighterToEditorIncrementally(HighlightingSessionImpl.this.myProject, HighlightingSessionImpl.this.myDocument, HighlightingSessionImpl.this.getPsiFile(), HighlightingSessionImpl.this.myRestrictRange.getStartOffset(), HighlightingSessionImpl.this.myRestrictRange.getEndOffset(), info, colorsScheme, 4, HighlightingSessionImpl.this.myRanges2markersCache);
                return true;
            }
        }, new Condition<Object>(){

            @Override
            public boolean value(Object o) {
                return HighlightingSessionImpl.this.myProject.isDisposed() || HighlightingSessionImpl.this.getProgressIndicator().isCanceled();
            }
        }, 200);
        this.myDisposeHighlighterInEDTQueue = new TransferToEDTQueue<RangeHighlighterEx>("Dispose abandoned highlighter", new Processor<RangeHighlighterEx>(){

            @Override
            public boolean process(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl$3", "process"));
                }
                highlighter.dispose();
                return true;
            }
        }, new Condition<Object>(){

            @Override
            public boolean value(Object o) {
                return HighlightingSessionImpl.this.myProject.isDisposed() || HighlightingSessionImpl.this.getProgressIndicator().isCanceled();
            }
        }, 200);
        this.myPsiFile = psiFile;
        this.myEditor = editor;
        this.myProgressIndicator = progressIndicator;
        this.myEditorColorsScheme = editorColorsScheme;
        this.myPassId = passId;
        this.myRestrictRange = restrictRange;
        this.myProject = psiFile.getProject();
        this.myDocument = PsiDocumentManager.getInstance(this.myProject).getDocument(psiFile);
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getPsiFile"));
        }
        return psiFile;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getDocument"));
        }
        return document;
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getProgressIndicator"));
        }
        return progressIndicator;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getProject"));
        }
        return project;
    }

    @Override
    public EditorColorsScheme getColorsScheme() {
        return this.myEditorColorsScheme;
    }

    @Override
    public int getPassId() {
        return this.myPassId;
    }

    void queueHighlightInfo(@NotNull HighlightInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "queueHighlightInfo"));
        }
        this.myAddHighlighterInEDTQueue.offer(info);
    }

    void queueDisposeHighlighter(RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            return;
        }
        this.myDisposeHighlighterInEDTQueue.offer(highlighter);
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
    }
}

