/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreModule;
import com.intellij.core.CoreProjectLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jdom.JDOMException;

public class CoreModuleManager
extends ModuleManagerImpl {
    private final Disposable myParentDisposable;

    public CoreModuleManager(Project project, Disposable parentDisposable) {
        super(project, project.getMessageBus());
        this.myParentDisposable = parentDisposable;
    }

    @Override
    protected ModuleEx createModule(String filePath) {
        return new CoreModule(this.myParentDisposable, this.myProject, filePath);
    }

    @Override
    protected ModuleEx createAndLoadModule(String filePath) throws IOException {
        ModuleEx module = this.createModule(filePath);
        VirtualFile vFile = StandardFileSystems.local().findFileByPath(filePath);
        try {
            assert (vFile != null);
            StorageData storageData = CoreProjectLoader.loadStorageFile(module, vFile);
            ModuleRootManagerImpl.ModuleRootManagerState state = new ModuleRootManagerImpl.ModuleRootManagerState();
            state.readExternal(storageData.getState("NewModuleRootManager"));
            ((ModuleRootManagerImpl)ModuleRootManager.getInstance(module)).loadState(state);
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
        return module;
    }

    @Override
    protected void deliverPendingEvents() {
    }

    public void loadModules() {
        this.loadModules(this.myModuleModel);
    }

    protected Disposable getLifetime() {
        return this.myParentDisposable;
    }
}

