/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorStacked;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DoubleArrayList;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AbstractProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicatorStacked {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private volatile String myText;
    private volatile double myFraction;
    private volatile String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myFinished;
    private volatile boolean myIndeterminate;
    private Stack<String> myTextStack;
    private DoubleArrayList myFractionStack;
    private Stack<String> myText2Stack;
    private volatile int myNonCancelableCount;
    protected ProgressIndicator myModalityProgress;
    private volatile ModalityState myModalityState = ModalityState.NON_MODAL;
    private static final Set<Class> ourReportedReuseExceptions = ContainerUtil.newConcurrentSet();

    @Override
    public synchronized void start() {
        LOG.assertTrue(!this.isRunning(), "Attempt to start ProgressIndicator which is already running");
        if (this.myFinished) {
            if (this.myCanceled && !this.isReuseable() && ourReportedReuseExceptions.add(this.getClass())) {
                LOG.error("Attempt to start ProgressIndicator which is cancelled and already stopped:" + this + "," + this.getClass());
            }
            this.myCanceled = false;
            this.myFinished = false;
        }
        this.myText = "";
        this.myFraction = 0.0;
        this.myText2 = "";
        this.myRunning = true;
    }

    protected boolean isReuseable() {
        return false;
    }

    @Override
    public synchronized void stop() {
        LOG.assertTrue(this.myRunning, "stop() should be called only if start() called before");
        this.myRunning = false;
        this.myFinished = true;
    }

    @Override
    public boolean isRunning() {
        return this.myRunning;
    }

    @Override
    public void cancel() {
        this.myCanceled = true;
        ProgressManager.canceled(this);
    }

    @Override
    public boolean isCanceled() {
        return this.myCanceled;
    }

    @Override
    public void checkCanceled() {
        if (this.isCanceled() && this.isCancelable()) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public void setText(String text) {
        this.myText = text;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public void setText2(String text) {
        this.myText2 = text;
    }

    @Override
    public String getText2() {
        return this.myText2;
    }

    @Override
    public double getFraction() {
        return this.myFraction;
    }

    @Override
    public void setFraction(double fraction) {
        this.myFraction = fraction;
    }

    @Override
    public synchronized void pushState() {
        if (this.myTextStack == null) {
            this.myTextStack = new Stack(2);
        }
        this.myTextStack.push(this.myText);
        if (this.myFractionStack == null) {
            this.myFractionStack = new DoubleArrayList(2);
        }
        this.myFractionStack.add(this.myFraction);
        if (this.myText2Stack == null) {
            this.myText2Stack = new Stack(2);
        }
        this.myText2Stack.push(this.myText2);
    }

    @Override
    public synchronized void popState() {
        LOG.assertTrue(!this.myTextStack.isEmpty());
        String oldText = this.myTextStack.pop();
        double oldFraction = this.myFractionStack.remove(this.myFractionStack.size() - 1);
        String oldText2 = this.myText2Stack.pop();
        this.setText(oldText);
        this.setFraction(oldFraction);
        this.setText2(oldText2);
    }

    @Override
    public void startNonCancelableSection() {
        ++this.myNonCancelableCount;
    }

    @Override
    public void finishNonCancelableSection() {
        --this.myNonCancelableCount;
    }

    protected boolean isCancelable() {
        return this.myNonCancelableCount == 0;
    }

    @Override
    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    @Override
    @NotNull
    public final ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase", "getModalityState"));
        }
        return modalityState;
    }

    @Override
    public void setModalityProgress(ProgressIndicator modalityProgress) {
        LOG.assertTrue(!this.isRunning());
        this.myModalityProgress = modalityProgress;
        ModalityState currentModality = ApplicationManager.getApplication().getCurrentModalityState();
        this.myModalityState = this.myModalityProgress != null ? ((ModalityStateEx)currentModality).appendProgress(this.myModalityProgress) : currentModality;
    }

    @Override
    public boolean isIndeterminate() {
        return this.myIndeterminate;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.myIndeterminate = indeterminate;
    }

    @NonNls
    public String toString() {
        return "ProgressIndicator " + System.identityHashCode(this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    @Override
    public boolean isPopupWasShown() {
        return true;
    }

    @Override
    public boolean isShowing() {
        return this.isModal();
    }

    @Override
    public synchronized void initStateFrom(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase", "initStateFrom"));
        }
        this.myRunning = indicator.isRunning();
        this.myCanceled = indicator.isCanceled();
        this.myFraction = indicator.getFraction();
        this.myIndeterminate = indicator.isIndeterminate();
        this.myText = indicator.getText();
        this.myText2 = indicator.getText2();
        this.myFraction = indicator.getFraction();
        if (indicator instanceof ProgressIndicatorStacked) {
            ProgressIndicatorStacked stacked = (ProgressIndicatorStacked)indicator;
            this.myNonCancelableCount = stacked.getNonCancelableCount();
            this.myTextStack = new Stack<String>((Collection<String>)stacked.getTextStack());
            this.myText2Stack = new Stack<String>((Collection<String>)stacked.getText2Stack());
            this.myFractionStack = new DoubleArrayList(stacked.getFractionStack());
        }
    }

    @Override
    @NotNull
    public synchronized Stack<String> getTextStack() {
        if (this.myTextStack == null) {
            this.myTextStack = new Stack(2);
        }
        Stack<String> stack = this.myTextStack;
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase", "getTextStack"));
        }
        return stack;
    }

    @Override
    @NotNull
    public synchronized DoubleArrayList getFractionStack() {
        if (this.myFractionStack == null) {
            this.myFractionStack = new DoubleArrayList(2);
        }
        DoubleArrayList doubleArrayList = this.myFractionStack;
        if (doubleArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase", "getFractionStack"));
        }
        return doubleArrayList;
    }

    @Override
    @NotNull
    public synchronized Stack<String> getText2Stack() {
        if (this.myText2Stack == null) {
            this.myText2Stack = new Stack(2);
        }
        Stack<String> stack = this.myText2Stack;
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase", "getText2Stack"));
        }
        return stack;
    }

    @Override
    public int getNonCancelableCount() {
        return this.myNonCancelableCount;
    }
}

