/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableContentEntry;
import com.intellij.openapi.roots.impl.ClonableContentFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.ExcludeFolderImpl;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.SourceFolderImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;

public class ContentEntryImpl
extends RootModelComponentBase
implements ContentEntry,
ClonableContentEntry,
Comparable<ContentEntryImpl> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.SimpleContentEntryImpl");
    @NotNull
    private final VirtualFilePointer myRoot;
    @NonNls
    public static final String ELEMENT_NAME = "content";
    private final Set<SourceFolder> mySourceFolders;
    private final Set<ExcludeFolder> myExcludeFolders;
    @NonNls
    public static final String URL_ATTRIBUTE = "url";

    ContentEntryImpl(@NotNull VirtualFile file, @NotNull RootModelImpl m) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ContentEntryImpl", "<init>"));
        }
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/openapi/roots/impl/ContentEntryImpl", "<init>"));
        }
        this(file.getUrl(), m);
    }

    ContentEntryImpl(@NotNull String url, @NotNull RootModelImpl m) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTRIBUTE, "com/intellij/openapi/roots/impl/ContentEntryImpl", "<init>"));
        }
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/openapi/roots/impl/ContentEntryImpl", "<init>"));
        }
        super(m);
        this.mySourceFolders = new LinkedHashSet<SourceFolder>();
        this.myExcludeFolders = new TreeSet<ContentFolder>(ContentFolderComparator.INSTANCE);
        this.myRoot = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
    }

    ContentEntryImpl(@NotNull Element e, @NotNull RootModelImpl m) throws InvalidDataException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/impl/ContentEntryImpl", "<init>"));
        }
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/openapi/roots/impl/ContentEntryImpl", "<init>"));
        }
        this(ContentEntryImpl.getUrlFrom(e), m);
        this.initSourceFolders(e);
        this.initExcludeFolders(e);
    }

    private static String getUrlFrom(@NotNull Element e) throws InvalidDataException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getUrlFrom"));
        }
        LOG.assertTrue(ELEMENT_NAME.equals(e.getName()));
        String url = e.getAttributeValue(URL_ATTRIBUTE);
        if (url == null) {
            throw new InvalidDataException();
        }
        return url;
    }

    private void initSourceFolders(@NotNull Element e) throws InvalidDataException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/impl/ContentEntryImpl", "initSourceFolders"));
        }
        for (Element child : e.getChildren("sourceFolder")) {
            this.addSourceFolder(new SourceFolderImpl(child, this));
        }
    }

    private void initExcludeFolders(@NotNull Element e) throws InvalidDataException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/impl/ContentEntryImpl", "initExcludeFolders"));
        }
        for (Element child : e.getChildren("excludeFolder")) {
            ExcludeFolderImpl excludeFolder = new ExcludeFolderImpl(child, this);
            this.addExcludeFolder(excludeFolder);
        }
    }

    @Override
    public VirtualFile getFile() {
        return this.myRoot.getFile();
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.myRoot.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getUrl"));
        }
        return string;
    }

    @Override
    @NotNull
    public SourceFolder[] getSourceFolders() {
        SourceFolder[] sourceFolderArray = this.mySourceFolders.toArray(new SourceFolder[this.mySourceFolders.size()]);
        if (sourceFolderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getSourceFolders"));
        }
        return sourceFolderArray;
    }

    @Override
    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getSourceFolders"));
        }
        List<SourceFolder> list = this.getSourceFolders(Collections.singleton(rootType));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getSourceFolders"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypes", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getSourceFolders"));
        }
        SmartList<SourceFolder> folders = new SmartList<SourceFolder>();
        for (SourceFolder folder : this.mySourceFolders) {
            if (!rootTypes.contains(folder.getRootType())) continue;
            folders.add(folder);
        }
        SmartList<SourceFolder> smartList = folders;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getSourceFolders"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceFolderFiles() {
        assert (!this.isDisposed());
        SourceFolder[] sourceFolders = this.getSourceFolders();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(sourceFolders.length);
        for (SourceFolder sourceFolder : sourceFolders) {
            VirtualFile file = sourceFolder.getFile();
            if (file == null) continue;
            result.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getSourceFolderFiles"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public ExcludeFolder[] getExcludeFolders() {
        ExcludeFolder[] excludeFolderArray = this.myExcludeFolders.toArray(new ExcludeFolder[this.myExcludeFolders.size()]);
        if (excludeFolderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getExcludeFolders"));
        }
        return excludeFolderArray;
    }

    @Override
    @NotNull
    public List<String> getExcludeFolderUrls() {
        ArrayList<String> excluded = new ArrayList<String>();
        for (ExcludeFolder folder : this.myExcludeFolders) {
            excluded.add(folder.getUrl());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.getRootModel().getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.getRootModel())) {
                excluded.add(pointer.getUrl());
            }
        }
        ArrayList<String> arrayList = excluded;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getExcludeFolderUrls"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public VirtualFile[] getExcludeFolderFiles() {
        assert (!this.isDisposed());
        ArrayList result = new ArrayList();
        for (ExcludeFolder excludeFolder : this.getExcludeFolders()) {
            ContainerUtil.addIfNotNull(result, excludeFolder.getFile());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.getRootModel().getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.getRootModel())) {
                ContainerUtil.addIfNotNull(result, pointer.getFile());
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "getExcludeFolderFiles"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(file, isTestSource, "");
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource, @NotNull String packagePrefix) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        JavaSourceRootType type = isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        SourceFolder sourceFolder = this.addSourceFolder(file, type);
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        this.assertCanAddFolder(file);
        SourceFolder sourceFolder = this.addSourceFolder(new SourceFolderImpl(file, JpsElementFactory.getInstance().createModuleSourceRoot(file.getUrl(), type, properties), this));
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file, @NotNull JpsModuleSourceRootType<P> type) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(file, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull String url, boolean isTestSource) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTRIBUTE, "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTRIBUTE, "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTRIBUTE, "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        this.assertFolderUnderMe(url);
        JpsModuleSourceRoot sourceRoot = JpsElementFactory.getInstance().createModuleSourceRoot(url, type, properties);
        SourceFolder sourceFolder = this.addSourceFolder(new SourceFolderImpl(sourceRoot, this));
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @NotNull
    private SourceFolder addSourceFolder(@NotNull SourceFolderImpl f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        this.mySourceFolders.add(f);
        Disposer.register(this, f);
        SourceFolderImpl sourceFolderImpl = f;
        if (sourceFolderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addSourceFolder"));
        }
        return sourceFolderImpl;
    }

    @Override
    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFolder", "com/intellij/openapi/roots/impl/ContentEntryImpl", "removeSourceFolder"));
        }
        assert (!this.isDisposed());
        this.assertCanRemoveFrom(sourceFolder, this.mySourceFolders);
        this.doRemove(sourceFolder);
    }

    private void doRemove(SourceFolder sourceFolder) {
        this.mySourceFolders.remove(sourceFolder);
        Disposer.dispose((Disposable)((Object)sourceFolder));
    }

    @Override
    public void clearSourceFolders() {
        assert (!this.isDisposed());
        this.getRootModel().assertWritable();
        for (SourceFolder folder : this.mySourceFolders) {
            Disposer.dispose((Disposable)((Object)folder));
        }
        this.mySourceFolders.clear();
    }

    @Override
    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ContentEntryImpl", "addExcludeFolder"));
        }
        assert (!this.isDisposed());
        this.assertCanAddFolder(file);
        return this.addExcludeFolder(new ExcludeFolderImpl(file, this));
    }

    @Override
    public ExcludeFolder addExcludeFolder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTRIBUTE, "com/intellij/openapi/roots/impl/ContentEntryImpl", "addExcludeFolder"));
        }
        assert (!this.isDisposed());
        this.assertCanAddFolder(url);
        return this.addExcludeFolder(new ExcludeFolderImpl(url, this));
    }

    private void assertCanAddFolder(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ContentEntryImpl", "assertCanAddFolder"));
        }
        this.assertCanAddFolder(file.getUrl());
    }

    private void assertCanAddFolder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTRIBUTE, "com/intellij/openapi/roots/impl/ContentEntryImpl", "assertCanAddFolder"));
        }
        this.getRootModel().assertWritable();
        this.assertFolderUnderMe(url);
    }

    @Override
    public void removeExcludeFolder(@NotNull ExcludeFolder excludeFolder) {
        if (excludeFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeFolder", "com/intellij/openapi/roots/impl/ContentEntryImpl", "removeExcludeFolder"));
        }
        assert (!this.isDisposed());
        this.assertCanRemoveFrom(excludeFolder, this.myExcludeFolders);
        this.myExcludeFolders.remove(excludeFolder);
        Disposer.dispose((Disposable)((Object)excludeFolder));
    }

    @Override
    public boolean removeExcludeFolder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTRIBUTE, "com/intellij/openapi/roots/impl/ContentEntryImpl", "removeExcludeFolder"));
        }
        for (ExcludeFolder folder : this.myExcludeFolders) {
            if (!folder.getUrl().equals(url)) continue;
            this.myExcludeFolders.remove(folder);
            Disposer.dispose((Disposable)((Object)folder));
            return true;
        }
        return false;
    }

    @Override
    public void clearExcludeFolders() {
        assert (!this.isDisposed());
        this.getRootModel().assertWritable();
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            Disposer.dispose((Disposable)((Object)excludeFolder));
        }
        this.myExcludeFolders.clear();
    }

    private ExcludeFolder addExcludeFolder(ExcludeFolder f) {
        Disposer.register(this, (Disposable)((Object)f));
        this.myExcludeFolders.add(f);
        return f;
    }

    private <T extends ContentFolder> void assertCanRemoveFrom(T f, @NotNull Set<T> ff) {
        if (ff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ff", "com/intellij/openapi/roots/impl/ContentEntryImpl", "assertCanRemoveFrom"));
        }
        this.getRootModel().assertWritable();
        LOG.assertTrue(ff.contains(f));
    }

    private void assertFolderUnderMe(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTRIBUTE, "com/intellij/openapi/roots/impl/ContentEntryImpl", "assertFolderUnderMe"));
        }
        String path = VfsUtilCore.urlToPath(url);
        String rootPath = VfsUtilCore.urlToPath(this.getUrl());
        if (!FileUtil.isAncestor(rootPath, path, false)) {
            LOG.error("The file '" + path + "' is not under content entry root '" + rootPath + "'");
        }
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    @NotNull
    public ContentEntry cloneEntry(@NotNull RootModelImpl rootModel) {
        ContentFolder folder;
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ContentEntryImpl", "cloneEntry"));
        }
        assert (!this.isDisposed());
        ContentEntryImpl cloned = new ContentEntryImpl(this.myRoot.getUrl(), rootModel);
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            if (!(sourceFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)((Object)sourceFolder)).cloneFolder(cloned);
            cloned.addSourceFolder((SourceFolderImpl)folder);
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            if (!(excludeFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)((Object)excludeFolder)).cloneFolder(cloned);
            cloned.addExcludeFolder((ExcludeFolder)folder);
        }
        ContentEntryImpl contentEntryImpl = cloned;
        if (contentEntryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ContentEntryImpl", "cloneEntry"));
        }
        return contentEntryImpl;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/ContentEntryImpl", "writeExternal"));
        }
        assert (!this.isDisposed());
        LOG.assertTrue(ELEMENT_NAME.equals(element.getName()));
        element.setAttribute(URL_ATTRIBUTE, this.myRoot.getUrl());
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            if (!(sourceFolder instanceof SourceFolderImpl)) continue;
            JpsModuleRootModelSerializer.saveSourceRoot(element, sourceFolder.getUrl(), sourceFolder.getJpsElement().asTyped());
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            if (!(excludeFolder instanceof ExcludeFolderImpl)) continue;
            Element subElement = new Element("excludeFolder");
            ((ExcludeFolderImpl)excludeFolder).writeExternal(subElement);
            element.addContent(subElement);
        }
    }

    @Override
    public int compareTo(@NotNull ContentEntryImpl other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/openapi/roots/impl/ContentEntryImpl", "compareTo"));
        }
        int i = this.getUrl().compareTo(other.getUrl());
        if (i != 0) {
            return i;
        }
        i = ArrayUtil.lexicographicCompare(this.getSourceFolders(), other.getSourceFolders());
        if (i != 0) {
            return i;
        }
        return ArrayUtil.lexicographicCompare(this.getExcludeFolders(), other.getExcludeFolders());
    }

    private static final class ContentFolderComparator
    implements Comparator<ContentFolder> {
        public static final ContentFolderComparator INSTANCE = new ContentFolderComparator();

        private ContentFolderComparator() {
        }

        @Override
        public int compare(@NotNull ContentFolder o1, @NotNull ContentFolder o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/roots/impl/ContentEntryImpl$ContentFolderComparator", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/roots/impl/ContentEntryImpl$ContentFolderComparator", "compare"));
            }
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }
}

