/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsReferenceParameterListImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsJavaCodeReferenceElementImpl
extends ClsElementImpl
implements PsiJavaCodeReferenceElement {
    private final PsiElement myParent;
    private final String myCanonicalText;
    private final String myQualifiedName;
    private final PsiReferenceParameterList myRefParameterList;

    public ClsJavaCodeReferenceElementImpl(PsiElement parent, @NotNull String canonicalText) {
        String canonical;
        if (canonicalText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canonicalText", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "<init>"));
        }
        this.myParent = parent;
        this.myCanonicalText = canonical = TypeInfo.internFrequentType(canonicalText);
        String qName = TypeInfo.internFrequentType(PsiNameHelper.getQualifiedClassName(this.myCanonicalText, false));
        this.myQualifiedName = qName.equals(canonical) ? canonical : qName;
        String[] classParameters = PsiNameHelper.getClassParametersText(canonicalText);
        this.myRefParameterList = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl(this, classParameters);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getChildren"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        return PsiNameHelper.getPresentableText(this);
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getCanonicalText"));
        }
        return string;
    }

    private JavaResolveResult advancedResolveImpl(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "advancedResolveImpl"));
        }
        PsiTypeElement[] typeElements = this.myRefParameterList == null ? PsiTypeElement.EMPTY_ARRAY : this.myRefParameterList.getTypeParameterElements();
        PsiElement resolve = this.resolveElement(containingFile);
        if (resolve == null) {
            return null;
        }
        if (resolve instanceof PsiClass) {
            HashMap<PsiTypeParameter, PsiType> substitutionMap = new HashMap<PsiTypeParameter, PsiType>();
            int index = 0;
            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiClass)resolve)) {
                if (index >= typeElements.length) {
                    PsiTypeParameterListOwner parameterOwner = parameter.getOwner();
                    if (parameterOwner == resolve) {
                        substitutionMap.put(parameter, null);
                    } else if (parameterOwner instanceof PsiClass) {
                        PsiElement containingClass = this.myParent;
                        while ((containingClass = PsiTreeUtil.getParentOfType(containingClass, PsiClass.class, true)) != null) {
                            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)parameterOwner, (PsiClass)containingClass, PsiSubstitutor.EMPTY);
                            if (superClassSubstitutor == null) continue;
                            substitutionMap.put(parameter, superClassSubstitutor.substitute(parameter));
                            break;
                        }
                    }
                } else {
                    substitutionMap.put(parameter, typeElements[index].getType());
                }
                ++index;
            }
            this.collectOuterClassTypeArgs((PsiClass)resolve, this.myCanonicalText, substitutionMap);
            return new CandidateInfo(resolve, PsiSubstitutorImpl.createSubstitutor(substitutionMap));
        }
        return new CandidateInfo(resolve, PsiSubstitutor.EMPTY);
    }

    private void collectOuterClassTypeArgs(@NotNull PsiClass psiClass, String canonicalText, Map<PsiTypeParameter, PsiType> substitutionMap) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "collectOuterClassTypeArgs"));
        }
        PsiClass containingClass = psiClass.getContainingClass();
        if (containingClass != null && !containingClass.hasModifierProperty("static")) {
            String outerClassRef = StringUtil.getPackageName(canonicalText);
            String[] classParameters = PsiNameHelper.getClassParametersText(outerClassRef);
            PsiType[] args = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl(this, classParameters).getTypeArguments();
            PsiTypeParameter[] typeParameters = containingClass.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (args == null || i >= args.length) continue;
                substitutionMap.put(typeParameters[i], args[i]);
            }
            this.collectOuterClassTypeArgs(containingClass, outerClassRef, substitutionMap);
        }
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            JavaResolveResult javaResolveResult = results[0];
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "advancedResolve"));
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "advancedResolve"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file = this.getContainingFile();
        ResolveCache resolveCache = ResolveCache.getInstance(file.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, Resolver.INSTANCE, true, incompleteCode, file);
        if (results.length == 0) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Nullable
    private PsiElement resolveElement(@NotNull PsiFile containingFile) {
        PsiElement element;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "resolveElement"));
        }
        for (element = this.getParent(); element != null && (!(element instanceof PsiClass) || element instanceof PsiTypeParameter); element = element.getParent()) {
            PsiMethod method;
            PsiTypeParameterList list;
            if (!(element instanceof PsiMethod) || (list = (method = (PsiMethod)element).getTypeParameterList()) == null) continue;
            PsiTypeParameter[] parameters = list.getTypeParameters();
            for (int i = 0; parameters != null && i < parameters.length; ++i) {
                PsiTypeParameter parameter = parameters[i];
                if (!this.myQualifiedName.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        if (element == null) {
            return null;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)element)) {
            if (!this.myQualifiedName.equals(parameter.getName())) continue;
            return parameter;
        }
        return this.resolveClassPreferringMyJar(containingFile);
    }

    @Nullable
    private PsiClass resolveClassPreferringMyJar(@NotNull PsiFile containingFile) {
        VirtualFile jarFile;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "resolveClassPreferringMyJar"));
        }
        Project project = containingFile.getProject();
        GlobalSearchScope scope = ResolveScopeManager.getInstance(project).getResolveScope(this);
        PsiClass[] classes = JavaPsiFacade.getInstance(project).findClasses(this.myQualifiedName, scope);
        if (classes.length == 0) {
            return null;
        }
        if (classes.length > 1 && (jarFile = PsiUtil.getJarFile(containingFile)) != null) {
            for (PsiClass aClass : classes) {
                if (!Comparing.equal(PsiUtil.getJarFile(aClass), jarFile)) continue;
                return aClass;
            }
        }
        return classes[0];
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "processVariants"));
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return this.myRefParameterList;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public String getReferenceName() {
        return PsiNameHelper.getShortClassName(this.myCanonicalText);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "bindToElement"));
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)element;
        return this.myCanonicalText.equals(aClass.getQualifiedName()) || this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "appendMirrorText"));
        }
        buffer.append(this.getCanonicalText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.JAVA_CODE_REFERENCE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiType[] psiTypeArray = this.myRefParameterList == null ? PsiType.EMPTY_ARRAY : this.myRefParameterList.getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getTypeParameters"));
        }
        return psiTypeArray;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantContextResolver<ClsJavaCodeReferenceElementImpl> {
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @NotNull
        public JavaResolveResult[] resolve(@NotNull ClsJavaCodeReferenceElementImpl ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver", "resolve"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver", "resolve"));
            }
            JavaResolveResult resolveResult = ref.advancedResolveImpl(containingFile);
            if (resolveResult == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = resolveResult;
            }
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver", "resolve"));
            }
            return javaResolveResultArray;
        }
    }
}

