/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionsMustHaveInitialCapacityInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> collectionClassesRequiringCapacity = new HashSet<String>();

    @Override
    @NotNull
    public String getID() {
        if ("CollectionWithoutInitialCapacity" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection", "getID"));
        }
        return "CollectionWithoutInitialCapacity";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("collections.must.have.initial.capacity.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("collections.must.have.initial.capacity.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionInitialCapacityVisitor();
    }

    static {
        collectionClassesRequiringCapacity.add("java.util.concurrent.ConcurrentHashMap");
        collectionClassesRequiringCapacity.add("java.util.concurrent.PriorityBlockingQueue");
        collectionClassesRequiringCapacity.add("java.util.ArrayDeque");
        collectionClassesRequiringCapacity.add("java.util.ArrayList");
        collectionClassesRequiringCapacity.add("java.util.BitSet");
        collectionClassesRequiringCapacity.add("java.util.HashMap");
        collectionClassesRequiringCapacity.add("java.util.Hashtable");
        collectionClassesRequiringCapacity.add("java.util.HashSet");
        collectionClassesRequiringCapacity.add("java.util.IdentityHashMap");
        collectionClassesRequiringCapacity.add("java.util.LinkedHashMap");
        collectionClassesRequiringCapacity.add("java.util.LinkedHashSet");
        collectionClassesRequiringCapacity.add("java.util.PriorityQueue");
        collectionClassesRequiringCapacity.add("java.util.Vector");
        collectionClassesRequiringCapacity.add("java.util.WeakHashMap");
    }

    private static class CollectionInitialCapacityVisitor
    extends BaseInspectionVisitor {
        private CollectionInitialCapacityVisitor() {
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection$CollectionInitialCapacityVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (!CollectionInitialCapacityVisitor.isCollectionWithInitialCapacity(type)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null || argumentList.getExpressions().length != 0) {
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }

        public static boolean isCollectionWithInitialCapacity(@Nullable PsiType type) {
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass resolved = classType.resolve();
            if (resolved == null) {
                return false;
            }
            String className = resolved.getQualifiedName();
            return collectionClassesRequiringCapacity.contains(className);
        }
    }
}

