/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class QueryExecutorBase<Result, Params>
implements QueryExecutor<Result, Params> {
    private final boolean myRequireReadAction;

    protected QueryExecutorBase(boolean requireReadAction) {
        this.myRequireReadAction = requireReadAction;
    }

    protected QueryExecutorBase() {
        this(false);
    }

    @Override
    public final boolean execute(final @NotNull Params queryParameters, final @NotNull Processor<Result> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/openapi/application/QueryExecutorBase", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/application/QueryExecutorBase", "execute"));
        }
        final AtomicBoolean toContinue = new AtomicBoolean(true);
        final Processor wrapper = new Processor<Result>(){

            @Override
            public boolean process(Result result) {
                if (!toContinue.get()) {
                    return false;
                }
                if (!consumer.process(result)) {
                    toContinue.set(false);
                    return false;
                }
                return true;
            }
        };
        if (this.myRequireReadAction) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    QueryExecutorBase.this.processQuery(queryParameters, wrapper);
                }
            });
        } else {
            this.processQuery(queryParameters, wrapper);
        }
        return toContinue.get();
    }

    public abstract void processQuery(@NotNull Params var1, @NotNull Processor<Result> var2);
}

