/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ContentBasedClassFileProcessor;
import com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHighlighterFactoryImpl
extends EditorHighlighterFactory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.highlighter.EditorHighlighterFactoryImpl");

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(SyntaxHighlighter highlighter, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        if (highlighter == null) {
            highlighter = new PlainSyntaxHighlighter();
        }
        LexerEditorHighlighter lexerEditorHighlighter = new LexerEditorHighlighter(highlighter, colors);
        if (lexerEditorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return lexerEditorHighlighter;
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull FileType fileType, @NotNull EditorColorsScheme settings, Project project) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        if (fileType instanceof LanguageFileType) {
            EditorHighlighter editorHighlighter = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project, fileType, null, settings);
            if (editorHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
            }
            return editorHighlighter;
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, project, null);
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(highlighter, settings);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project, @NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(fileType, EditorColorsManager.getInstance().getGlobalScheme(), project);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull VirtualFile vFile, @NotNull EditorColorsScheme settings, @Nullable Project project) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        FileType fileType = vFile.getFileType();
        if (fileType instanceof LanguageFileType) {
            EditorHighlighter editorHighlighter;
            LanguageFileType substFileType = EditorHighlighterFactoryImpl.substituteFileType(((LanguageFileType)fileType).getLanguage(), vFile, project);
            if (substFileType != null) {
                boolean isPlain;
                EditorHighlighterProvider provider = (EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(substFileType);
                EditorHighlighter editorHighlighter2 = provider.getEditorHighlighter(project, fileType, vFile, settings);
                boolean bl = isPlain = editorHighlighter2.getClass() == LexerEditorHighlighter.class && ((LexerEditorHighlighter)editorHighlighter2).isPlain();
                if (!isPlain) {
                    EditorHighlighter editorHighlighter3 = editorHighlighter2;
                    if (editorHighlighter3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
                    }
                    return editorHighlighter3;
                }
            }
            try {
                editorHighlighter = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project, fileType, vFile, settings);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
            if (editorHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
            }
            return editorHighlighter;
        }
        SyntaxHighlighter highlighter = null;
        for (ContentBasedFileSubstitutor processor : Extensions.getExtensions(ContentBasedFileSubstitutor.EP_NAME)) {
            boolean applicable;
            try {
                applicable = processor.isApplicable(project, vFile);
            }
            catch (Exception e) {
                LOG.error(e);
                continue;
            }
            if (!applicable || !(processor instanceof ContentBasedClassFileProcessor)) continue;
            highlighter = ((ContentBasedClassFileProcessor)processor).createHighlighter(project, vFile);
        }
        if (highlighter == null) {
            highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, project, vFile);
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(highlighter, settings);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @Nullable
    private static LanguageFileType substituteFileType(Language language, VirtualFile vFile, Project project) {
        Language substLanguage;
        LanguageFileType fileType = null;
        if (vFile != null && project != null && (substLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, vFile, project)) != language) {
            fileType = substLanguage.getAssociatedFileType();
        }
        return fileType;
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(file, EditorColorsManager.getInstance().getGlobalScheme(), project);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project, @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme(), fileName, project);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull EditorColorsScheme settings, @NotNull String fileName, @Nullable Project project) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        EditorHighlighter editorHighlighter = this.createEditorHighlighter(new LightVirtualFile(fileName), settings, project);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl", "createEditorHighlighter"));
        }
        return editorHighlighter;
    }
}

