/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CachedValueBase;
import org.jetbrains.annotations.NotNull;

public abstract class PsiCachedValue<T>
extends CachedValueBase<T> {
    private final PsiManager myManager;
    protected long myLastPsiTimeStamp;

    public PsiCachedValue(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/PsiCachedValue", "<init>"));
        }
        this.myLastPsiTimeStamp = -1L;
        this.myManager = manager;
    }

    @Override
    protected CachedValueBase.Data<T> computeData(T value, Object[] dependencies) {
        CachedValueBase.Data<T> data = super.computeData(value, dependencies);
        this.myLastPsiTimeStamp = this.myManager.getModificationTracker().getModificationCount();
        return data;
    }

    @Override
    protected boolean isUpToDate(@NotNull CachedValueBase.Data data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/psi/impl/PsiCachedValue", "isUpToDate"));
        }
        return !this.myManager.isDisposed() && super.isUpToDate(data);
    }

    @Override
    protected boolean isDependencyOutOfDate(Object dependency, long oldTimeStamp) {
        if (dependency instanceof PsiElement && this.myLastPsiTimeStamp == this.myManager.getModificationTracker().getModificationCount() && ((PsiElement)dependency).isValid() && ((PsiElement)dependency).isPhysical()) {
            return false;
        }
        return super.isDependencyOutOfDate(dependency, oldTimeStamp);
    }

    @Override
    protected long getTimeStamp(Object dependency) {
        if (dependency instanceof PsiDirectory) {
            return this.myManager.getModificationTracker().getOutOfCodeBlockModificationCount();
        }
        if (dependency instanceof PsiElement) {
            PsiElement element = (PsiElement)dependency;
            if (!element.isValid()) {
                return -1L;
            }
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) {
                return -1L;
            }
            return containingFile.getModificationStamp();
        }
        if (dependency == PsiModificationTracker.MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getModificationCount();
        }
        if (dependency == PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getOutOfCodeBlockModificationCount();
        }
        if (dependency == PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getJavaStructureModificationCount();
        }
        return super.getTimeStamp(dependency);
    }

    @Override
    public boolean isFromMyProject(Project project) {
        return this.myManager.getProject() == project;
    }
}

