/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBinaryFileImpl
extends PsiElementBase
implements PsiBinaryFile,
Cloneable,
Queryable {
    private final PsiManagerImpl myManager;
    private String myName;
    private byte[] myContents;
    private final long myModificationStamp;
    private final FileType myFileType;
    private final FileViewProvider myViewProvider;

    public PsiBinaryFileImpl(PsiManagerImpl manager, FileViewProvider viewProvider) {
        this.myViewProvider = viewProvider;
        this.myManager = manager;
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        this.myModificationStamp = virtualFile.getModificationStamp();
        this.myFileType = viewProvider.getVirtualFile().getFileType();
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    public byte[] getStoredContents() {
        return this.myContents;
    }

    @Override
    @NotNull
    public String getName() {
        String string = !this.isCopy() ? this.getVirtualFile().getName() : this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "setName"));
        }
        this.checkSetName(name);
        if (this.isCopy()) {
            this.myName = name;
            return this;
        }
        return PsiFileImplUtil.setName(this, name);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        if (this.isCopy()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Nullable
    public PsiDirectory getParentDirectory() {
        return this.getContainingDirectory();
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "getLanguage"));
        }
        return language;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "getChildren"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return this;
    }

    @Override
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public int getTextLength() {
        return -1;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "textToCharArray"));
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "textMatches"));
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "textMatches"));
        }
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "accept"));
        }
        visitor.visitBinaryFile(this);
    }

    @Override
    public PsiElement copy() {
        PsiBinaryFileImpl clone = (PsiBinaryFileImpl)this.clone();
        clone.myName = this.getName();
        try {
            clone.myContents = !this.isCopy() ? this.getVirtualFile().contentsToByteArray() : this.myContents;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return clone;
    }

    private boolean isCopy() {
        return this.myName != null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "add"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "addBefore"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "addAfter"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "checkAdd"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (this.isCopy()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "replace"));
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.isCopy()) {
            return true;
        }
        return this.getVirtualFile().isValid() && !this.myManager.getProject().isDisposed() && this.myManager.getFileManager().findFile(this.getVirtualFile()) == this;
    }

    @Override
    public boolean isWritable() {
        return this.isCopy() || this.getVirtualFile().isWritable();
    }

    @Override
    public boolean isPhysical() {
        return !this.isCopy();
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        PsiBinaryFileImpl psiBinaryFileImpl = this;
        if (psiBinaryFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "getOriginalFile"));
        }
        return psiBinaryFileImpl;
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiBinaryFile:" + this.getName();
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "getFileType"));
        }
        return fileType;
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "getPsiRoots"));
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    @Override
    public FileASTNode getNode() {
        return null;
    }

    @Override
    public void subtreeChanged() {
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/file/PsiBinaryFileImpl", "putInfo"));
        }
        info.put("fileName", this.getName());
        info.put("fileType", this.getFileType().getName());
    }
}

