/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.LiteralFormatUtil;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralExpressionImpl
extends ExpressionPsiElement
implements PsiLiteralExpression,
PsiLanguageInjectionHost,
ContributedReferenceHost {
    @NonNls
    private static final String QUOT = "&quot;";
    @NonNls
    public static final String HEX_PREFIX = "0x";
    @NonNls
    public static final String BIN_PREFIX = "0b";
    @NonNls
    public static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    public static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);
    public static final TokenSet INTEGER_LITERALS = TokenSet.create(JavaTokenType.INTEGER_LITERAL, JavaTokenType.LONG_LITERAL);
    public static final TokenSet REAL_LITERALS = TokenSet.create(JavaTokenType.FLOAT_LITERAL, JavaTokenType.DOUBLE_LITERAL);
    public static final TokenSet NUMERIC_LITERALS = TokenSet.orSet(INTEGER_LITERALS, REAL_LITERALS);

    public PsiLiteralExpressionImpl() {
        super(JavaElementType.LITERAL_EXPRESSION);
    }

    @Override
    public PsiType getType() {
        IElementType type = this.getLiteralElementType();
        if (type == JavaTokenType.INTEGER_LITERAL) {
            return PsiType.INT;
        }
        if (type == JavaTokenType.LONG_LITERAL) {
            return PsiType.LONG;
        }
        if (type == JavaTokenType.FLOAT_LITERAL) {
            return PsiType.FLOAT;
        }
        if (type == JavaTokenType.DOUBLE_LITERAL) {
            return PsiType.DOUBLE;
        }
        if (type == JavaTokenType.CHARACTER_LITERAL) {
            return PsiType.CHAR;
        }
        if (type == JavaTokenType.STRING_LITERAL) {
            PsiManager manager = this.getManager();
            GlobalSearchScope resolveScope = ResolveScopeManager.getElementResolveScope(this);
            return PsiType.getJavaLangString(manager, resolveScope);
        }
        if (type == JavaTokenType.TRUE_KEYWORD || type == JavaTokenType.FALSE_KEYWORD) {
            return PsiType.BOOLEAN;
        }
        if (type == JavaTokenType.NULL_KEYWORD) {
            return PsiType.NULL;
        }
        return null;
    }

    public IElementType getLiteralElementType() {
        return this.getFirstChildNode().getElementType();
    }

    public String getCanonicalText() {
        TreeElement literal = this.getFirstChildNode();
        IElementType type = literal.getElementType();
        return NUMERIC_LITERALS.contains(type) ? LiteralFormatUtil.removeUnderscores(literal.getText()) : literal.getText();
    }

    @Override
    public Object getValue() {
        IElementType type = this.getLiteralElementType();
        String text = NUMERIC_LITERALS.contains(type) ? this.getCanonicalText().toLowerCase(Locale.ENGLISH) : this.getCanonicalText();
        int textLength = text.length();
        if (type == JavaTokenType.INTEGER_LITERAL) {
            try {
                if (text.startsWith(HEX_PREFIX)) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text.substring(2), 4, 32);
                    return (int)value;
                }
                if (text.startsWith(BIN_PREFIX)) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text.substring(2), 1, 32);
                    return (int)value;
                }
                if (StringUtil.startsWithChar(text, '0')) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text, 3, 32);
                    return (int)value;
                }
                long l = Long.parseLong(text, 10);
                if (text.equals(_2_IN_31)) {
                    return (int)l;
                }
                long converted = (int)l;
                return l == converted ? Integer.valueOf((int)l) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == JavaTokenType.LONG_LITERAL) {
            if (StringUtil.endsWithChar(text, 'L') || StringUtil.endsWithChar(text, 'l')) {
                text = text.substring(0, textLength - 1);
            }
            try {
                if (text.startsWith(HEX_PREFIX)) {
                    return PsiLiteralExpressionImpl.parseDigits(text.substring(2), 4, 64);
                }
                if (text.startsWith(BIN_PREFIX)) {
                    return PsiLiteralExpressionImpl.parseDigits(text.substring(2), 1, 64);
                }
                if (StringUtil.startsWithChar(text, '0')) {
                    return PsiLiteralExpressionImpl.parseDigits(text, 3, 64);
                }
                if (_2_IN_63.equals(text)) {
                    return Long.MIN_VALUE;
                }
                return Long.valueOf(text, 10);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == JavaTokenType.FLOAT_LITERAL) {
            try {
                return Float.valueOf(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == JavaTokenType.DOUBLE_LITERAL) {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == JavaTokenType.CHARACTER_LITERAL) {
            if (StringUtil.endsWithChar(text, '\'')) {
                if (textLength == 1) {
                    return null;
                }
                text = text.substring(1, textLength - 1);
            } else {
                text = text.substring(1, textLength);
            }
            StringBuilder chars = new StringBuilder();
            boolean success = PsiLiteralExpressionImpl.parseStringCharacters(text, chars, null);
            if (!success) {
                return null;
            }
            if (chars.length() != 1) {
                return null;
            }
            return Character.valueOf(chars.charAt(0));
        }
        if (type == JavaTokenType.STRING_LITERAL) {
            String innerText = this.getInnerText();
            return innerText == null ? null : PsiLiteralExpressionImpl.internedParseStringCharacters(innerText);
        }
        if (type == JavaTokenType.TRUE_KEYWORD) {
            return Boolean.TRUE;
        }
        if (type == JavaTokenType.FALSE_KEYWORD) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Nullable
    public String getInnerText() {
        String text = this.getCanonicalText();
        int textLength = text.length();
        if (StringUtil.endsWithChar(text, '\"')) {
            if (textLength == 1) {
                return null;
            }
            text = text.substring(1, textLength - 1);
        } else if (text.startsWith(QUOT) && text.endsWith(QUOT) && textLength > QUOT.length()) {
            text = text.substring(QUOT.length(), textLength - QUOT.length());
        } else {
            return null;
        }
        return text;
    }

    private static long parseDigits(String text, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int radix = 1 << bitsInRadix;
        int textLength = text.length();
        if (textLength == 0) {
            throw new NumberFormatException(text);
        }
        long l = integer = textLength == 1 ? 0L : Long.parseLong(text.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text);
        }
        int lastDigit = Character.digit(text.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }

    @Nullable
    private static String internedParseStringCharacters(String chars) {
        StringBuilder outChars = new StringBuilder(chars.length());
        boolean success = PsiLiteralExpressionImpl.parseStringCharacters(chars, outChars, null);
        return success ? outChars.toString() : null;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "parseStringCharacters"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "parseStringCharacters"));
        }
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c = chars.charAt(index++);
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    break;
                }
                case 't': {
                    outChars.append('\t');
                    break;
                }
                case 'n': {
                    outChars.append('\n');
                    break;
                }
                case 'f': {
                    outChars.append('\f');
                    break;
                }
                case 'r': {
                    outChars.append('\r');
                    break;
                }
                case '\"': {
                    outChars.append('\"');
                    break;
                }
                case '\'': {
                    outChars.append('\'');
                    break;
                }
                case '\\': {
                    outChars.append('\\');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v = c - 48;
                    if (index < chars.length()) {
                        if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                            if (startC <= '3' && index < chars.length()) {
                                if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                    v <<= 3;
                                    v += c - 48;
                                } else {
                                    --index;
                                }
                            }
                        } else {
                            --index;
                        }
                    }
                    outChars.append((char)v);
                    break;
                }
                case 'u': {
                    while (index != chars.length() && chars.charAt(index) == 'u') {
                        ++index;
                    }
                    if (index + 4 <= chars.length()) {
                        try {
                            int code = Integer.parseInt(chars.substring(index, index + 4), 16);
                            if (code == 10 || code == 13) {
                                return false;
                            }
                            c = chars.charAt(index);
                            if (c == '+' || c == '-') {
                                return false;
                            }
                            outChars.append((char)code);
                            index += 4;
                            break;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = index;
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLiteralExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiLiteralExpression:" + this.getText();
    }

    @Override
    public boolean isValidHost() {
        return this.getValue() instanceof String;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        IElementType type = this.getLiteralElementType();
        if (type != JavaTokenType.STRING_LITERAL && type != JavaTokenType.INTEGER_LITERAL) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = PsiReferenceService.getService().getContributedReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "updateText"));
        }
        TreeElement valueNode = this.getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<PsiLiteralExpressionImpl> createLiteralTextEscaper() {
        StringLiteralEscaper<PsiLiteralExpressionImpl> stringLiteralEscaper = new StringLiteralEscaper<PsiLiteralExpressionImpl>(this);
        if (stringLiteralEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl", "createLiteralTextEscaper"));
        }
        return stringLiteralEscaper;
    }
}

