/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.BaseExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.dataFlow.ContractInference;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullityInference;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.PurityInference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferredAnnotationsManagerImpl
extends InferredAnnotationsManager {
    private final Project myProject;

    public InferredAnnotationsManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        PsiAnnotation anno;
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "findInferredAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "findInferredAnnotation"));
        }
        listOwner = BaseExternalAnnotationsManager.preferCompiledElement(listOwner);
        if (ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN) && listOwner instanceof PsiMethod && (anno = this.getHardcodedContractAnnotation((PsiMethod)listOwner)) != null) {
            return anno;
        }
        if (this.ignoreInference(listOwner, annotationFQN)) {
            return null;
        }
        PsiAnnotation fromBytecode = ProjectBytecodeAnalysis.getInstance(this.myProject).findInferredAnnotation(listOwner, annotationFQN);
        if (fromBytecode != null) {
            return fromBytecode;
        }
        if (listOwner instanceof PsiMethod) {
            if (ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN)) {
                return this.getInferredContractAnnotation((PsiMethod)listOwner);
            }
            if ("org.jetbrains.annotations.NotNull".equals(annotationFQN) || "org.jetbrains.annotations.Nullable".equals(annotationFQN)) {
                PsiAnnotation anno2 = this.getInferredNullityAnnotation((PsiMethod)listOwner);
                return anno2 == null ? null : (annotationFQN.equals(anno2.getQualifiedName()) ? anno2 : null);
            }
        }
        return null;
    }

    @Nullable
    private PsiAnnotation getHardcodedContractAnnotation(PsiMethod method) {
        List<MethodContract> contracts = HardcodedContracts.getHardcodedContracts(method, null);
        return contracts.isEmpty() ? null : this.createContractAnnotation(contracts, HardcodedContracts.isHardcodedPure(method));
    }

    @Override
    public boolean ignoreInference(@NotNull PsiModifierListOwner owner, @Nullable String annotationFQN) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "ignoreInference"));
        }
        if (owner instanceof PsiMethod && PsiUtil.canBeOverriden((PsiMethod)owner)) {
            return true;
        }
        if (ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN) && HardcodedContracts.hasHardcodedContracts(owner)) {
            return true;
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotationFQN) && owner instanceof PsiParameter && owner.getParent() != null) {
            if (AnnotationUtil.isAnnotated(owner, NullableNotNullManager.getInstance(owner.getProject()).getNullables(), false, false)) {
                return true;
            }
            if (HardcodedContracts.hasHardcodedContracts(owner)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private PsiAnnotation getInferredContractAnnotation(PsiMethod method) {
        if (method.getModifierList().findAnnotation(ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT) != null) {
            return null;
        }
        return this.createContractAnnotation(ContractInference.inferContracts(method), PurityInference.inferPurity(method));
    }

    @Nullable
    private PsiAnnotation getInferredNullityAnnotation(PsiMethod method) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance(this.myProject);
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)method, manager.getNotNulls(), true) != null || AnnotationUtil.findAnnotation((PsiModifierListOwner)method, manager.getNullables(), true) != null) {
            return null;
        }
        Nullness nullness = NullityInference.inferNullity(method);
        if (nullness == Nullness.NOT_NULL) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNotNullAnnotation();
        }
        if (nullness == Nullness.NULLABLE) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNullableAnnotation();
        }
        return null;
    }

    @Nullable
    private PsiAnnotation createContractAnnotation(List<MethodContract> contracts, boolean pure) {
        String attrs;
        if (!contracts.isEmpty() && pure) {
            attrs = "value = \"" + StringUtil.join(contracts, "; ") + "\", pure = true";
        } else if (pure) {
            attrs = "pure = true";
        } else if (!contracts.isEmpty()) {
            attrs = "\"" + StringUtil.join(contracts, "; ") + "\"";
        } else {
            return null;
        }
        return ProjectBytecodeAnalysis.getInstance(this.myProject).createContractAnnotation(attrs);
    }

    @Override
    @NotNull
    public PsiAnnotation[] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        PsiAnnotation[] fromBytecode;
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "findInferredAnnotations"));
        }
        listOwner = BaseExternalAnnotationsManager.preferCompiledElement(listOwner);
        ArrayList<PsiAnnotation> result = ContainerUtil.newArrayList();
        for (PsiAnnotation annotation : fromBytecode = ProjectBytecodeAnalysis.getInstance(this.myProject).findInferredAnnotations(listOwner)) {
            if (this.ignoreInference(listOwner, annotation.getQualifiedName())) continue;
            result.add(annotation);
        }
        if (listOwner instanceof PsiMethod) {
            PsiAnnotation annotation;
            PsiAnnotation hardcoded = this.getHardcodedContractAnnotation((PsiMethod)listOwner);
            if (hardcoded != null) {
                result.add(hardcoded);
            } else if (!this.ignoreInference(listOwner, ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
                ContainerUtil.addIfNotNull(result, this.getInferredContractAnnotation((PsiMethod)listOwner));
            }
            if (!(this.ignoreInference(listOwner, "org.jetbrains.annotations.NotNull") && this.ignoreInference(listOwner, "org.jetbrains.annotations.Nullable") || (annotation = this.getInferredNullityAnnotation((PsiMethod)listOwner)) == null || this.ignoreInference(listOwner, annotation.getQualifiedName()))) {
                result.add(annotation);
            }
        }
        PsiAnnotation[] psiAnnotationArray = result.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : result.toArray(new PsiAnnotation[result.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "findInferredAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "isInferredAnnotation"));
        }
        return annotation.getUserData(ProjectBytecodeAnalysis.INFERRED_ANNOTATION) != null;
    }
}

