/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom;

import com.intellij.ide.highlighter.custom.tokens.KeywordParser;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class SyntaxTable
implements Cloneable {
    private Set<String> myKeywords1 = new TreeSet<String>();
    private Set<String> myKeywords2 = new TreeSet<String>();
    private Set<String> myKeywords3 = new TreeSet<String>();
    private Set<String> myKeywords4 = new TreeSet<String>();
    private String myLineComment = "";
    public boolean lineCommentOnlyAtStart;
    private String myStartComment;
    private String myEndComment;
    private String myHexPrefix;
    private String myNumPostfixChars;
    private boolean myIgnoreCase;
    private boolean myHasBraces;
    private boolean myHasBrackets;
    private boolean myHasParens;
    private boolean myHasStringEscapes;
    private volatile KeywordParser myKeywordParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeywordParser getKeywordParser() {
        KeywordParser parser = this.myKeywordParser;
        if (parser == null) {
            SyntaxTable syntaxTable = this;
            synchronized (syntaxTable) {
                parser = this.myKeywordParser;
                if (parser == null) {
                    this.myKeywordParser = parser = new KeywordParser(Arrays.asList(this.myKeywords1, this.myKeywords2, this.myKeywords3, this.myKeywords4), this.myIgnoreCase);
                }
            }
        }
        return parser;
    }

    protected Object clone() throws CloneNotSupportedException {
        SyntaxTable cl = (SyntaxTable)super.clone();
        cl.myKeywords1 = new TreeSet<String>(this.myKeywords1);
        cl.myKeywords2 = new TreeSet<String>(this.myKeywords2);
        cl.myKeywords3 = new TreeSet<String>(this.myKeywords3);
        cl.myKeywords4 = new TreeSet<String>(this.myKeywords4);
        cl.myKeywordParser = null;
        return cl;
    }

    public void addKeyword1(String keyword) {
        this.myKeywords1.add(keyword);
        this.myKeywordParser = null;
    }

    public Set<String> getKeywords1() {
        return this.myKeywords1;
    }

    public void addKeyword2(String keyword) {
        this.myKeywords2.add(keyword);
        this.myKeywordParser = null;
    }

    public Set<String> getKeywords2() {
        return this.myKeywords2;
    }

    public void addKeyword3(String keyword) {
        this.myKeywords3.add(keyword);
        this.myKeywordParser = null;
    }

    public Set<String> getKeywords3() {
        return this.myKeywords3;
    }

    public void addKeyword4(String keyword) {
        this.myKeywords4.add(keyword);
        this.myKeywordParser = null;
    }

    public Set<String> getKeywords4() {
        return this.myKeywords4;
    }

    @NotNull
    public String getLineComment() {
        String string = this.myLineComment;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/custom/SyntaxTable", "getLineComment"));
        }
        return string;
    }

    public void setLineComment(@NotNull String lineComment) {
        if (lineComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineComment", "com/intellij/ide/highlighter/custom/SyntaxTable", "setLineComment"));
        }
        this.myLineComment = lineComment;
    }

    public String getStartComment() {
        return this.myStartComment;
    }

    public void setStartComment(String startComment) {
        this.myStartComment = startComment;
    }

    public String getEndComment() {
        return this.myEndComment;
    }

    public void setEndComment(String endComment) {
        this.myEndComment = endComment;
    }

    public String getHexPrefix() {
        return this.myHexPrefix;
    }

    public void setHexPrefix(String hexPrefix) {
        this.myHexPrefix = hexPrefix;
    }

    public String getNumPostfixChars() {
        return this.myNumPostfixChars;
    }

    public void setNumPostfixChars(String numPostfixChars) {
        this.myNumPostfixChars = numPostfixChars;
    }

    public boolean isIgnoreCase() {
        return this.myIgnoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.myIgnoreCase = ignoreCase;
        this.myKeywordParser = null;
    }

    public boolean isHasBraces() {
        return this.myHasBraces;
    }

    public void setHasBraces(boolean hasBraces) {
        this.myHasBraces = hasBraces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyntaxTable)) {
            return false;
        }
        SyntaxTable syntaxTable = (SyntaxTable)o;
        if (this.myIgnoreCase != syntaxTable.myIgnoreCase) {
            return false;
        }
        if (this.myEndComment != null ? !this.myEndComment.equals(syntaxTable.myEndComment) : syntaxTable.myEndComment != null) {
            return false;
        }
        if (this.myHexPrefix != null ? !this.myHexPrefix.equals(syntaxTable.myHexPrefix) : syntaxTable.myHexPrefix != null) {
            return false;
        }
        if (!((Object)this.myKeywords1).equals(syntaxTable.myKeywords1)) {
            return false;
        }
        if (!((Object)this.myKeywords2).equals(syntaxTable.myKeywords2)) {
            return false;
        }
        if (!((Object)this.myKeywords3).equals(syntaxTable.myKeywords3)) {
            return false;
        }
        if (!((Object)this.myKeywords4).equals(syntaxTable.myKeywords4)) {
            return false;
        }
        if (this.myLineComment != null ? !this.myLineComment.equals(syntaxTable.myLineComment) : syntaxTable.myLineComment != null) {
            return false;
        }
        if (this.myNumPostfixChars != null ? !this.myNumPostfixChars.equals(syntaxTable.myNumPostfixChars) : syntaxTable.myNumPostfixChars != null) {
            return false;
        }
        if (this.myStartComment != null ? !this.myStartComment.equals(syntaxTable.myStartComment) : syntaxTable.myStartComment != null) {
            return false;
        }
        if (this.myHasBraces != syntaxTable.myHasBraces) {
            return false;
        }
        if (this.myHasBrackets != syntaxTable.myHasBrackets) {
            return false;
        }
        if (this.myHasParens != syntaxTable.myHasParens) {
            return false;
        }
        if (this.myHasStringEscapes != syntaxTable.myHasStringEscapes) {
            return false;
        }
        return this.lineCommentOnlyAtStart == syntaxTable.lineCommentOnlyAtStart;
    }

    public int hashCode() {
        return ((Object)this.myKeywords1).hashCode();
    }

    public boolean isHasBrackets() {
        return this.myHasBrackets;
    }

    public boolean isHasParens() {
        return this.myHasParens;
    }

    public void setHasBrackets(boolean hasBrackets) {
        this.myHasBrackets = hasBrackets;
    }

    public void setHasParens(boolean hasParens) {
        this.myHasParens = hasParens;
    }

    public boolean isHasStringEscapes() {
        return this.myHasStringEscapes;
    }

    public void setHasStringEscapes(boolean hasEscapes) {
        this.myHasStringEscapes = hasEscapes;
    }
}

