/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.RangeHighlighterTree;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RangeHighlighterImpl
extends RangeMarkerImpl
implements RangeHighlighterEx,
Getter<RangeHighlighterEx> {
    private static final Color NULL_COLOR = new Color(0, 0, 0);
    private final MarkupModel myModel;
    private TextAttributes myTextAttributes;
    private LineMarkerRenderer myLineMarkerRenderer;
    private Color myErrorStripeColor;
    private Color myLineSeparatorColor;
    private SeparatorPlacement mySeparatorPlacement;
    private GutterIconRenderer myGutterIconRenderer;
    private Object myErrorStripeTooltip;
    private MarkupEditorFilter myFilter;
    private CustomHighlighterRenderer myCustomRenderer;
    private LineSeparatorRenderer myLineSeparatorRenderer;
    private byte myFlags;
    private static final byte AFTER_END_OF_LINE_MASK = 1;
    private static final byte ERROR_STRIPE_IS_THIN_MASK = 2;
    private static final byte TARGET_AREA_IS_EXACT_MASK = 4;
    private static final byte IN_BATCH_CHANGE_MASK = 8;
    private static final byte CHANGED_MASK = 16;
    private static final byte RENDERERS_CHANGED_MASK = 32;

    RangeHighlighterImpl(@NotNull MarkupModel model, int start, int end, int layer, @NotNull HighlighterTargetArea target, TextAttributes textAttributes, boolean greedyToLeft, boolean greedyToRight) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "<init>"));
        }
        super((DocumentEx)model.getDocument(), start, end, false);
        this.myFilter = MarkupEditorFilter.EMPTY;
        this.myTextAttributes = textAttributes;
        this.setFlag((byte)4, target == HighlighterTargetArea.EXACT_RANGE);
        this.myModel = model;
        this.registerInTree(start, end, greedyToLeft, greedyToRight, layer);
    }

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet(this.myFlags, mask);
    }

    private void setFlag(@FlagConstant byte mask, boolean value) {
        this.myFlags = BitUtil.set(this.myFlags, mask, value);
    }

    @Override
    public TextAttributes getTextAttributes() {
        return this.myTextAttributes;
    }

    @Override
    public void setTextAttributes(@NotNull TextAttributes textAttributes) {
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributes", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "setTextAttributes"));
        }
        TextAttributes old = this.myTextAttributes;
        this.myTextAttributes = textAttributes;
        if (!Comparing.equal(old, textAttributes)) {
            this.fireChanged(false);
        }
    }

    @Override
    @NotNull
    public HighlighterTargetArea getTargetArea() {
        HighlighterTargetArea highlighterTargetArea = this.isFlagSet((byte)4) ? HighlighterTargetArea.EXACT_RANGE : HighlighterTargetArea.LINES_IN_RANGE;
        if (highlighterTargetArea == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "getTargetArea"));
        }
        return highlighterTargetArea;
    }

    @Override
    public LineMarkerRenderer getLineMarkerRenderer() {
        return this.myLineMarkerRenderer;
    }

    @Override
    public void setLineMarkerRenderer(LineMarkerRenderer renderer) {
        LineMarkerRenderer old = this.myLineMarkerRenderer;
        this.myLineMarkerRenderer = renderer;
        if (!Comparing.equal(old, renderer)) {
            this.fireChanged(true);
        }
    }

    @Override
    public CustomHighlighterRenderer getCustomRenderer() {
        return this.myCustomRenderer;
    }

    @Override
    public void setCustomRenderer(CustomHighlighterRenderer renderer) {
        CustomHighlighterRenderer old = this.myCustomRenderer;
        this.myCustomRenderer = renderer;
        if (!Comparing.equal(old, renderer)) {
            this.fireChanged(true);
        }
    }

    @Override
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    @Override
    public void setGutterIconRenderer(GutterIconRenderer renderer) {
        GutterIconRenderer old = this.myGutterIconRenderer;
        this.myGutterIconRenderer = renderer;
        if (!Comparing.equal(old, renderer)) {
            this.fireChanged(true);
        }
    }

    @Override
    public Color getErrorStripeMarkColor() {
        if (this.myErrorStripeColor == NULL_COLOR) {
            return null;
        }
        if (this.myErrorStripeColor != null) {
            return this.myErrorStripeColor;
        }
        if (this.myTextAttributes != null) {
            return this.myTextAttributes.getErrorStripeColor();
        }
        return null;
    }

    @Override
    public void setErrorStripeMarkColor(Color color) {
        if (color == null) {
            color = NULL_COLOR;
        }
        Color old = this.myErrorStripeColor;
        this.myErrorStripeColor = color;
        if (!Comparing.equal(old, color)) {
            this.fireChanged(false);
        }
    }

    @Override
    public Object getErrorStripeTooltip() {
        return this.myErrorStripeTooltip;
    }

    @Override
    public void setErrorStripeTooltip(Object tooltipObject) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object old = this.myErrorStripeTooltip;
        this.myErrorStripeTooltip = tooltipObject;
        if (!Comparing.equal(old, tooltipObject)) {
            this.fireChanged(false);
        }
    }

    @Override
    public boolean isThinErrorStripeMark() {
        return this.isFlagSet((byte)2);
    }

    @Override
    public void setThinErrorStripeMark(boolean value) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean old = this.isThinErrorStripeMark();
        this.setFlag((byte)2, value);
        if (old != value) {
            this.fireChanged(false);
        }
    }

    @Override
    public Color getLineSeparatorColor() {
        return this.myLineSeparatorColor;
    }

    @Override
    public void setLineSeparatorColor(Color color) {
        Color old = this.myLineSeparatorColor;
        this.myLineSeparatorColor = color;
        if (!Comparing.equal(old, color)) {
            this.fireChanged(false);
        }
    }

    @Override
    public SeparatorPlacement getLineSeparatorPlacement() {
        return this.mySeparatorPlacement;
    }

    @Override
    public void setLineSeparatorPlacement(@Nullable SeparatorPlacement placement) {
        SeparatorPlacement old = this.mySeparatorPlacement;
        this.mySeparatorPlacement = placement;
        if (!Comparing.equal(old, placement)) {
            this.fireChanged(false);
        }
    }

    @Override
    public void setEditorFilter(@NotNull MarkupEditorFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "setEditorFilter"));
        }
        this.myFilter = filter;
        this.fireChanged(false);
    }

    @Override
    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = this.myFilter;
        if (markupEditorFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "getEditorFilter"));
        }
        return markupEditorFilter;
    }

    @Override
    public boolean isAfterEndOfLine() {
        return this.isFlagSet((byte)1);
    }

    @Override
    public void setAfterEndOfLine(boolean afterEndOfLine) {
        boolean old = this.isAfterEndOfLine();
        this.setFlag((byte)1, afterEndOfLine);
        if (old != afterEndOfLine) {
            this.fireChanged(false);
        }
    }

    private void fireChanged(boolean renderersChanged) {
        if (this.myModel instanceof MarkupModelEx) {
            if (this.isFlagSet((byte)8)) {
                this.setFlag((byte)16, true);
                if (renderersChanged) {
                    this.setFlag((byte)32, true);
                }
            } else {
                ((MarkupModelEx)this.myModel).fireAttributesChanged(this, renderersChanged);
            }
        }
    }

    @Override
    public int getAffectedAreaStartOffset() {
        int startOffset = this.getStartOffset();
        switch (this.getTargetArea()) {
            case EXACT_RANGE: {
                return startOffset;
            }
            case LINES_IN_RANGE: {
                Document document = this.myModel.getDocument();
                int textLength = document.getTextLength();
                if (startOffset >= textLength) {
                    return textLength;
                }
                return document.getLineStartOffset(document.getLineNumber(startOffset));
            }
        }
        throw new IllegalStateException(this.getTargetArea().toString());
    }

    @Override
    public int getAffectedAreaEndOffset() {
        int endOffset = this.getEndOffset();
        switch (this.getTargetArea()) {
            case EXACT_RANGE: {
                return endOffset;
            }
            case LINES_IN_RANGE: {
                Document document = this.myModel.getDocument();
                int textLength = document.getTextLength();
                if (endOffset >= textLength) {
                    return endOffset;
                }
                return Math.min(textLength, document.getLineEndOffset(document.getLineNumber(endOffset)) + 1);
            }
        }
        throw new IllegalStateException(this.getTargetArea().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    ChangeResult changeAttributesNoEvents(@NotNull Consumer<RangeHighlighterEx> change) {
        ChangeResult changeResult;
        block7: {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "changeAttributesNoEvents"));
            }
            assert (!this.isFlagSet((byte)8));
            assert (!this.isFlagSet((byte)16));
            this.setFlag((byte)8, true);
            this.setFlag((byte)32, false);
            try {
                change.consume(this);
                this.setFlag((byte)8, false);
                boolean changed = this.isFlagSet((byte)16);
                boolean renderersChanged = this.isFlagSet((byte)32);
                if (changed) {
                    changeResult = renderersChanged ? ChangeResult.RENDERERS_CHANGED : ChangeResult.MINOR_CHANGE;
                    break block7;
                }
                changeResult = ChangeResult.NOT_CHANGED;
            }
            catch (Throwable throwable) {
                this.setFlag((byte)8, false);
                boolean changed = this.isFlagSet((byte)16);
                boolean renderersChanged = this.isFlagSet((byte)32);
                ChangeResult result = changed ? (renderersChanged ? ChangeResult.RENDERERS_CHANGED : ChangeResult.MINOR_CHANGE) : ChangeResult.NOT_CHANGED;
                this.setFlag((byte)16, false);
                this.setFlag((byte)32, false);
                throw throwable;
            }
        }
        ChangeResult result = changeResult;
        this.setFlag((byte)16, false);
        this.setFlag((byte)32, false);
        ChangeResult changeResult2 = result;
        if (changeResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "changeAttributesNoEvents"));
        }
        return changeResult2;
    }

    public MarkupModel getMarkupModel() {
        return this.myModel;
    }

    @Override
    public void setLineSeparatorRenderer(LineSeparatorRenderer renderer) {
        LineSeparatorRenderer old = this.myLineSeparatorRenderer;
        this.myLineSeparatorRenderer = renderer;
        if (!Comparing.equal(old, renderer)) {
            this.fireChanged(true);
        }
    }

    @Override
    public LineSeparatorRenderer getLineSeparatorRenderer() {
        return this.myLineSeparatorRenderer;
    }

    @Override
    protected void registerInTree(int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        ((MarkupModelEx)this.getMarkupModel()).addRangeHighlighter(this, start, end, greedyToLeft, greedyToRight, layer);
    }

    @Override
    protected boolean unregisterInTree() {
        if (!this.isValid()) {
            return false;
        }
        this.getMarkupModel().removeHighlighter(this);
        return true;
    }

    @Override
    public RangeHighlighterImpl get() {
        return this;
    }

    @Override
    public int getLayer() {
        RangeHighlighterTree.RHNode node = (RangeHighlighterTree.RHNode)this.myNode;
        return node == null ? -1 : node.myLayer;
    }

    @Override
    public String toString() {
        return "RangeHighlighter: (" + this.getStartOffset() + "," + this.getEndOffset() + "); layer:" + this.getLayer() + "; tooltip: " + this.getErrorStripeTooltip();
    }

    static enum ChangeResult {
        NOT_CHANGED,
        MINOR_CHANGE,
        RENDERERS_CHANGED;

    }

    private static @interface FlagConstant {
    }
}

