/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaFunctionalExpressionSearcher
implements QueryExecutor<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance("#" + JavaFunctionalExpressionSearcher.class.getName());

    @Override
    public boolean execute(final @NotNull FunctionalExpressionSearch.SearchParameters queryParameters, @NotNull Processor<PsiFunctionalExpression> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "execute"));
        }
        final PsiClass aClass = queryParameters.getElementToSearch();
        final HashSet<Module> highLevelModules = new HashSet<Module>();
        if (ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                if (LambdaUtil.isFunctionalClass(aClass)) {
                    Project project = aClass.getProject();
                    boolean projectLevelIsHigh = PsiUtil.getLanguageLevel(project).isAtLeast(LanguageLevel.JDK_1_8);
                    for (Module module : ModuleManager.getInstance(project).getModules()) {
                        LanguageLevel level;
                        LanguageLevelModuleExtension extension = ModuleRootManager.getInstance(module).getModuleExtension(LanguageLevelModuleExtension.class);
                        if (extension == null || ((level = extension.getLanguageLevel()) != null || !projectLevelIsHigh) && (level == null || !level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
                        highLevelModules.add(module);
                    }
                    return highLevelModules.isEmpty();
                }
                return true;
            }
        }).booleanValue()) {
            return true;
        }
        return JavaFunctionalExpressionSearcher.collectFunctionalExpressions(aClass, ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

            @Override
            public SearchScope compute() {
                return queryParameters.getEffectiveSearchScope();
            }
        }), consumer, highLevelModules);
    }

    public static boolean collectFunctionalExpressions(final PsiClass aClass, final SearchScope searchScope, final Processor<PsiFunctionalExpression> consumer, Set<Module> highLevelModules) {
        final SearchScope classScope = ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

            @Override
            public SearchScope compute() {
                return aClass.getUseScope();
            }
        });
        SearchScope useScope = ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

            @Override
            public SearchScope compute() {
                return searchScope.intersectWith(classScope);
            }
        });
        Project project = PsiUtilCore.getProjectInReadAction(aClass);
        final GlobalSearchScope scope = new ModulesScope(highLevelModules, project).intersectWith(useScope instanceof GlobalSearchScope ? (GlobalSearchScope)useScope : new EverythingGlobalScope(project));
        final ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
        HashSet files = new HashSet();
        CommonProcessors.CollectProcessor<VirtualFile> processor = new CommonProcessors.CollectProcessor<VirtualFile>(files){

            @Override
            protected boolean accept(VirtualFile virtualFile) {
                return scope.contains(virtualFile) && virtualFile.getFileType() == JavaFileType.INSTANCE && index.isInSource(virtualFile);
            }
        };
        PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance(project);
        helper.processFilesWithText(scope, (short)1, true, "::", (Processor<VirtualFile>)processor);
        helper.processFilesWithText(scope, (short)1, true, "->", (Processor<VirtualFile>)processor);
        LOG.info("#files: " + files.size());
        final PsiManager psiManager = PsiManager.getInstance(project);
        for (final VirtualFile file : files) {
            if (ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                @Override
                public Boolean compute() {
                    return JavaFunctionalExpressionSearcher.processFileWithFunctionalInterfaces(aClass, consumer, psiManager, file);
                }
            }).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean processFileWithFunctionalInterfaces(final PsiClass aClass, final Processor<PsiFunctionalExpression> consumer, PsiManager psiManager, VirtualFile file) {
        PsiFile psiFile = psiManager.findFile(file);
        if (psiFile != null) {
            final Ref<Boolean> ref = new Ref<Boolean>(true);
            psiFile.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitElement(PsiElement element) {
                    if (!((Boolean)ref.get()).booleanValue()) {
                        return;
                    }
                    super.visitElement(element);
                }

                private void visitFunctionalExpression(PsiFunctionalExpression expression) {
                    PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                    if (InheritanceUtil.isInheritorOrSelf(PsiUtil.resolveClassInType(functionalInterfaceType), aClass, true) && !consumer.process(expression)) {
                        ref.set(false);
                    }
                }

                @Override
                public void visitLambdaExpression(PsiLambdaExpression expression) {
                    super.visitLambdaExpression(expression);
                    this.visitFunctionalExpression(expression);
                }

                @Override
                public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                    super.visitMethodReferenceExpression(expression);
                    this.visitFunctionalExpression(expression);
                }
            });
            if (!ref.get().booleanValue()) {
                return false;
            }
        }
        return true;
    }
}

