/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdTagNameBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class XmlTagNamesIndex
extends XmlIndex<Void> {
    static final ID<String, Void> NAME = ID.create("XmlTagNames");

    public static Collection<VirtualFile> getFilesByTagName(String tagName, Project project) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, tagName, XmlTagNamesIndex.createFilter(project));
    }

    public static Collection<String> getAllTagNames(Project project) {
        return FileBasedIndex.getInstance().getAllKeys(NAME, project);
    }

    @Override
    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlTagNamesIndex", "getName"));
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = new DataIndexer<String, Void, FileContent>(){

            @Override
            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/xml/index/XmlTagNamesIndex$1", "map"));
                }
                Collection<String> tags = XsdTagNameBuilder.computeTagNames(CharArrayUtil.readerFromCharSequence(inputData.getContentAsText()));
                if (tags != null && !tags.isEmpty()) {
                    HashMap<String, Void> map = new HashMap<String, Void>(tags.size());
                    for (String tag : tags) {
                        map.put(tag, null);
                    }
                    HashMap<String, Void> hashMap = map;
                    if (hashMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlTagNamesIndex$1", "map"));
                    }
                    return hashMap;
                }
                Map<String, Void> map = Collections.emptyMap();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlTagNamesIndex$1", "map"));
                }
                return map;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlTagNamesIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @Override
    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        DataExternalizer<Void> dataExternalizer = ScalarIndexExtension.VOID_DATA_EXTERNALIZER;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlTagNamesIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }
}

