/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLocalVariableInspectionBase
extends BaseInspection {
    private static final String VARIABLES_NEW = "m_ignoreAnnotatedVariablesNew";
    public boolean m_ignoreImmediatelyReturnedVariables = false;
    @Deprecated
    public boolean m_ignoreAnnotatedVariables = false;
    public boolean m_ignoreAnnotatedVariablesNew = true;

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspectionBase", "writeSettings"));
        }
        DefaultJDOMExternalizer.writeExternal(this, node, new DefaultJDOMExternalizer.JDOMFilter(){

            @Override
            public boolean isAccept(@NotNull Field field) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspectionBase$1", "isAccept"));
                }
                return !Comparing.equal(UnnecessaryLocalVariableInspectionBase.VARIABLES_NEW, field.getName());
            }
        });
        if (!this.m_ignoreAnnotatedVariablesNew) {
            Element option = new Element("option");
            option.setAttribute("name", VARIABLES_NEW);
            option.setAttribute("value", Boolean.toString(this.m_ignoreAnnotatedVariablesNew));
            node.addContent(option);
        }
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.local.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("redundant.local.variable.ignore.option", new Object[0]), "m_ignoreImmediatelyReturnedVariables");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("redundant.local.variable.annotation.option", new Object[0]), VARIABLES_NEW);
        return optionsPanel;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.local.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLocalVariableVisitor();
    }

    private class UnnecessaryLocalVariableVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLocalVariableVisitor() {
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            PsiModifierList list;
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspectionBase$UnnecessaryLocalVariableVisitor", "visitLocalVariable"));
            }
            super.visitLocalVariable(variable);
            if (UnnecessaryLocalVariableInspectionBase.this.m_ignoreAnnotatedVariablesNew && (list = variable.getModifierList()) != null && list.getAnnotations().length > 0) {
                return;
            }
            if (this.isCopyVariable(variable)) {
                this.registerVariableError(variable, new Object[0]);
            } else if (!UnnecessaryLocalVariableInspectionBase.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyReturned(variable)) {
                this.registerVariableError(variable, new Object[0]);
            } else if (!UnnecessaryLocalVariableInspectionBase.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyThrown(variable)) {
                this.registerVariableError(variable, new Object[0]);
            } else if (this.isImmediatelyAssigned(variable)) {
                this.registerVariableError(variable, new Object[0]);
            } else if (this.isImmediatelyAssignedAsDeclaration(variable)) {
                this.registerVariableError(variable, new Object[0]);
            }
        }

        private boolean isCopyVariable(PsiVariable variable) {
            PsiExpression initializer = ParenthesesUtils.stripParentheses(variable.getInitializer());
            if (!(initializer instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)initializer;
            PsiElement referent = reference.resolve();
            if (referent == null) {
                return false;
            }
            if (!(referent instanceof PsiLocalVariable) && !(referent instanceof PsiParameter)) {
                return false;
            }
            if (!(referent instanceof PsiResourceVariable) && variable instanceof PsiResourceVariable) {
                return false;
            }
            PsiCodeBlock containingScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (containingScope == null) {
                return false;
            }
            if (!variable.hasModifierProperty("final") && VariableAccessUtils.variableIsAssigned(variable, containingScope, false)) {
                return false;
            }
            PsiVariable initialization = (PsiVariable)referent;
            if (!initialization.hasModifierProperty("final") && VariableAccessUtils.variableIsAssigned(initialization, containingScope, false)) {
                return false;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(containingScope.getProject()).getResolveHelper();
            String initializationName = initialization.getName();
            boolean finalVariableIntroduction = !initialization.hasModifierProperty("final") && variable.hasModifierProperty("final") || PsiUtil.isLanguageLevel8OrHigher(initialization) && !HighlightControlFlowUtil.isEffectivelyFinal(initialization, containingScope, null) && HighlightControlFlowUtil.isEffectivelyFinal(variable, containingScope, null);
            for (PsiReference ref : ReferencesSearch.search(variable, new LocalSearchScope(containingScope))) {
                Object element;
                PsiElement refElement = ref.getElement();
                if (finalVariableIntroduction && (element = PsiTreeUtil.getParentOfType(refElement, PsiClass.class, PsiLambdaExpression.class)) != null && PsiTreeUtil.isAncestor(containingScope, element, true)) {
                    return false;
                }
                if (resolveHelper.resolveReferencedVariable(initializationName, refElement) == initialization) continue;
                return false;
            }
            return !TypeConversionUtil.boxingConversionApplicable(variable.getType(), initialization.getType());
        }

        private boolean isImmediatelyReturned(PsiVariable variable) {
            PsiCodeBlock containingScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, true, PsiClass.class);
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = null;
            PsiStatement[] statements = containingScope.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
                break;
            }
            if (!(nextStatement instanceof PsiReturnStatement)) {
                return false;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)nextStatement;
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)returnValue;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            return !this.isVariableUsedInFollowingDeclarations(variable, declarationStatement);
        }

        private boolean isImmediatelyThrown(PsiVariable variable) {
            PsiCodeBlock containingScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, true, PsiClass.class);
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = null;
            PsiStatement[] statements = containingScope.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
                break;
            }
            if (!(nextStatement instanceof PsiThrowStatement)) {
                return false;
            }
            PsiThrowStatement throwStatement = (PsiThrowStatement)nextStatement;
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(throwStatement.getException());
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)((Object)returnValue)).resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            return !this.isVariableUsedInFollowingDeclarations(variable, declarationStatement);
        }

        private boolean isImmediatelyAssigned(PsiVariable variable) {
            PsiCodeBlock containingScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, true, PsiClass.class);
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = null;
            int followingStatementNumber = 0;
            PsiStatement[] statements = containingScope.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
                followingStatementNumber = i + 2;
                break;
            }
            if (!(nextStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)nextStatement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (tokenType != JavaTokenType.EQ) {
                return false;
            }
            PsiExpression rhs = ParenthesesUtils.stripParentheses(assignmentExpression.getRExpression());
            if (!(rhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)rhs;
            PsiElement referent = reference.resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (lhs instanceof PsiArrayAccessExpression) {
                return false;
            }
            if (this.isVariableUsedInFollowingDeclarations(variable, declarationStatement)) {
                return false;
            }
            for (int i = followingStatementNumber; i < statements.length; ++i) {
                if (!VariableAccessUtils.variableIsUsed(variable, statements[i])) continue;
                return false;
            }
            return true;
        }

        private boolean isImmediatelyAssignedAsDeclaration(PsiVariable variable) {
            PsiCodeBlock containingScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, true, PsiClass.class);
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = null;
            int followingStatementNumber = 0;
            PsiStatement[] statements = containingScope.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
                followingStatementNumber = i + 2;
                break;
            }
            if (nextStatement instanceof PsiDeclarationStatement) {
                boolean referenceFound = false;
                PsiDeclarationStatement nextDeclarationStatement = (PsiDeclarationStatement)nextStatement;
                for (PsiElement declaration : nextDeclarationStatement.getDeclaredElements()) {
                    PsiReferenceExpression referenceExpression;
                    PsiElement referent;
                    if (!(declaration instanceof PsiVariable)) continue;
                    PsiVariable nextVariable = (PsiVariable)declaration;
                    PsiExpression initializer = ParenthesesUtils.stripParentheses(nextVariable.getInitializer());
                    if (!referenceFound && initializer instanceof PsiReferenceExpression && variable.equals(referent = (referenceExpression = (PsiReferenceExpression)initializer).resolve())) {
                        referenceFound = true;
                        continue;
                    }
                    if (!VariableAccessUtils.variableIsUsed(variable, initializer)) continue;
                    return false;
                }
                if (!referenceFound) {
                    return false;
                }
            } else if (nextStatement instanceof PsiTryStatement) {
                PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
                PsiResourceList resourceList = tryStatement.getResourceList();
                if (resourceList == null) {
                    return false;
                }
                boolean referenceFound = false;
                for (PsiResourceVariable resourceVariable : resourceList.getResourceVariables()) {
                    PsiReferenceExpression referenceExpression;
                    PsiElement referent;
                    PsiExpression initializer = resourceVariable.getInitializer();
                    if (!referenceFound && initializer instanceof PsiReferenceExpression && variable.equals(referent = (referenceExpression = (PsiReferenceExpression)initializer).resolve())) {
                        referenceFound = true;
                        continue;
                    }
                    if (!VariableAccessUtils.variableIsUsed(variable, initializer)) continue;
                    return false;
                }
                if (!referenceFound) {
                    return false;
                }
                if (VariableAccessUtils.variableIsUsed(variable, tryStatement.getTryBlock()) || VariableAccessUtils.variableIsUsed(variable, tryStatement.getFinallyBlock())) {
                    return false;
                }
                for (PsiCatchSection section : tryStatement.getCatchSections()) {
                    if (!VariableAccessUtils.variableIsUsed(variable, section)) continue;
                    return false;
                }
            } else {
                return false;
            }
            if (this.isVariableUsedInFollowingDeclarations(variable, declarationStatement)) {
                return false;
            }
            for (int i = followingStatementNumber; i < statements.length; ++i) {
                if (!VariableAccessUtils.variableIsUsed(variable, statements[i])) continue;
                return false;
            }
            return true;
        }

        private boolean isVariableUsedInFollowingDeclarations(PsiVariable variable, PsiDeclarationStatement declarationStatement) {
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length == 1) {
                return false;
            }
            boolean check = false;
            for (PsiElement declaredElement : declaredElements) {
                if (!check && variable.equals(declaredElement)) {
                    check = true;
                    continue;
                }
                if (!VariableAccessUtils.variableIsUsed(variable, declaredElement)) continue;
                return true;
            }
            return false;
        }
    }
}

