/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class CallToSimpleGetterInClassInspectionBase
extends BaseInspection {
    public boolean ignoreGetterCallsOnOtherObjects = false;
    public boolean onlyReportPrivateGetter = false;

    @Override
    @NotNull
    public String getID() {
        if ("CallToSimpleGetterFromWithinClass" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspectionBase", "getID"));
        }
        return "CallToSimpleGetterFromWithinClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.simple.getter.in.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.simple.getter.in.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSimpleGetterInClassVisitor();
    }

    private class CallToSimpleGetterInClassVisitor
    extends BaseInspectionVisitor {
        private CallToSimpleGetterInClassVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspectionBase$CallToSimpleGetterInClassVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(call);
            PsiClass containingClass = ClassUtils.getContainingClass(call);
            if (containingClass == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            if (!containingClass.equals(method.getContainingClass())) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                if (CallToSimpleGetterInClassInspectionBase.this.ignoreGetterCallsOnOtherObjects) {
                    return;
                }
                PsiType type = qualifier.getType();
                if (!(type instanceof PsiClassType)) {
                    return;
                }
                PsiClassType classType = (PsiClassType)type;
                PsiClass qualifierClass = classType.resolve();
                if (!containingClass.equals(qualifierClass)) {
                    return;
                }
            }
            if (!PropertyUtil.isSimpleGetter(method)) {
                return;
            }
            if (CallToSimpleGetterInClassInspectionBase.this.onlyReportPrivateGetter && !method.hasModifierProperty("private")) {
                return;
            }
            Query<PsiMethod> query = OverridingMethodsSearch.search(method, true);
            PsiMethod overridingMethod = query.findFirst();
            if (overridingMethod != null) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }
    }
}

